/*---------------------------------------------------------------------------//
|
| You have to define the "GLUT_DIR" environment variable 
| pointing to your GLUT installation directory.
|  
|  13.4.2009, orthmann@uni-siegen.de
|
//-----------------------------------*/

// C++ header files
#include <string>
#include <sstream>
#include <cstdlib>

// OpenGL header files
#include <GL/glut.h>

#define ROTATION_INCREMENT 0.05f 
#define FPS 60              // That's a good frequency for LCD's
#define WIDTH 400
#define HEIGHT 400
#define FPS_REFRESH 1000    // ms

////////////////////////////////////////////////////////////
// GLOBAL VARIABLES ////////////////////////////////////////
////////////////////////////////////////////////////////////
int    g_fps   = 0;
int    g_counter = 0;
float  g_spin = 0.0f;
int    g_w = WIDTH;         // The GLUT window's width
int    g_h = HEIGHT;        // and height
float  g_boxWidth = 0.25f;

////////////////////////////////////////////////////////////
// FUNCTION DECLARATIONS ///////////////////////////////////
////////////////////////////////////////////////////////////
int  main(int argc, char** argv);
void init();
void drawString(const char* s);

void displayFunc();
void reshapeFunc(int w, int h);
void updateFunc();
void fpsFunc(int i);
void keyboardFunc(unsigned char key, int x, int y);

////////////////////////////////////////////////////////////
// FUNCTION DEFINITIONS ////////////////////////////////////
////////////////////////////////////////////////////////////
/** This function is the program entry point. */
int main(int argc, char** argv)
{
	// Initialize OpenGL window
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize(g_w, g_h);
	glutCreateWindow("GLUT EXAMPLE");

    init();
	
	// Define GLUT callback functions
	glutReshapeFunc(reshapeFunc);
	glutDisplayFunc(displayFunc);
	glutKeyboardFunc(keyboardFunc);
    glutIdleFunc( updateFunc );
	glutTimerFunc(FPS_REFRESH, fpsFunc, 0);
	
	// This starts everything related to GLUT...
	glutMainLoop();	
	return 0; 
}

void init()
{
    ////////////////
    // EXERCISE 2 //
    ////////////////
    GLfloat ambient[]  = {0.1f, 0.1f, 0.1f, 1.0f};
    GLfloat diffuse[]  = {0.5f, 0.5f, 0.75f, 1.0f};
    GLfloat specular[] = {0.25f, 0.25f, 0.25f, 1.0f};
    GLfloat light_position[] = { 0.0, 0.0, 1.0, 0.0 };

    GLfloat high_shininess = 25.0;
    glMaterialfv(GL_FRONT, GL_AMBIENT, ambient);
    glMaterialfv(GL_FRONT, GL_DIFFUSE, diffuse);
    glMaterialfv(GL_FRONT, GL_SPECULAR, specular);
    glMaterialf(GL_FRONT, GL_SHININESS, high_shininess);

    glLightfv(GL_LIGHT0, GL_POSITION, light_position);

    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);


    // Disable the following line if
    // OpenGL Material should be used.
    //glDisable(GL_LIGHTING);
    //glEnable( GL_COLOR_MATERIAL );

    /////////////
    // CULLING //
    /////////////
    glEnable( GL_CULL_FACE );
    glCullFace( GL_BACK ); 

    ///////////////////
    // SOME DEFAULTS //
    ///////////////////
    glEnable(GL_DEPTH_TEST);
    glClearColor( 0.05f, 0.05f, 0.05f, 0.0f );
}

/** 
 * This is the GLUT display function that is called 
 * each time the scene is drawn to the screen.
 */
void displayFunc()
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glPushMatrix();
	// {
		glTranslatef(0.0f, 0.0f, -10.0f * g_boxWidth); 
		glRotatef(g_spin, 0.0f, 1.0f, 0.0f); 	
        glRotatef(g_spin, 1.0f, 0.0f, 0.0f); 

        ////////////////
        // EXERCISE 1 //
        ////////////////

        // something is missing here

        glColor3f( 0,1,0 );
		glutSolidTorus(0.25, 0.75, 32, 32);
	// }
	glPopMatrix();

	std::stringstream s; 
	s << g_fps << " fps";
	drawString(s.str().c_str());

	glutSwapBuffers();
	glFlush();
	g_counter++;
}

/** This function is used to define the projection matrix. */
void reshapeFunc(int w, int h)
{
	glMatrixMode(GL_PROJECTION);
	glViewport(0, 0, (GLsizei)(g_w = w), (GLsizei)(g_h = h));
	glLoadIdentity();
	gluPerspective(45.0f, (GLdouble)w/(GLdouble)h, 1.0f, 256.0f);
	glMatrixMode(GL_MODELVIEW);
}

/** This function is called when a key is pushed. */
void keyboardFunc(unsigned char key, int x, int y)
{
	if (key == 27)
		exit(0);
}

/** This function changes the orientation of the object. */
void updateFunc()
{	
    g_spin += ROTATION_INCREMENT;
    glutPostRedisplay();
}

/** This function updates the FPS value. */
void fpsFunc(int i)
{	
	g_fps = g_counter;
	g_counter = 0;
	glutTimerFunc(FPS_REFRESH, fpsFunc, 0);
}

/** This function draws a string to the screen using GLUT. */
void drawString(const char* s)
{
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	// {
		glLoadIdentity();
		gluOrtho2D(0, g_w, 0, g_h);
		glViewport(0, 0, g_w, g_h);
		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		// {
			glLoadIdentity();
            glColor3f( 1,1,1 );
			glRasterPos2i(16, g_h-16);
			
			for (int i = 0; (i < 255) && (s[i] != '\0'); i++)
				glutBitmapCharacter(GLUT_BITMAP_8_BY_13, s[i]);
		// }
		glPopMatrix();
		glMatrixMode(GL_PROJECTION);
	// }
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
}
