#include "mainwindow.hpp"
#include "ui_mainwindow.h"

#include <QKeyEvent>
#include <iostream>

#include "gui/config.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    // setup ui elements
    ui->setupUi(this);

    // connect ui elements to slots
    connect(this->ui->sliderAnimationSpeed, SIGNAL(valueChanged(int)), this, SLOT(setAnimationSpeed(int)));
    connect(this->ui->checkBoxLocalRotation, SIGNAL(clicked(bool)), this, SLOT(setLocalRotation(bool)));
    /// TODO: connect all the UI you create
}

MainWindow::~MainWindow()
{
    delete ui;
}


void MainWindow::setAnimationSpeed(int value)
{
    Config::animationSpeed = float(value) / 2.0f;
    QString title = QString("Animation: ") + QString::number(Config::animationSpeed, 'x', 1) + "x";
    this->ui->groupBox_4->setTitle(title);
}

void MainWindow::setWireframe(bool value)
{
    /// TODO: your code here
}

void MainWindow::setLighting(bool value)
{
    /// TODO: your code here
}

void MainWindow::setCoordSystem(bool value)
{
    /// TODO: your code here
}

void MainWindow::setLocalRotation(bool value)
{
    Config::localRotation = value;
}

void MainWindow::setGlobalRotation(bool value)
{
    /// TODO: your code here
}

void MainWindow::setOrbit(bool value)
{
    /// TODO: your code here
}

void MainWindow::setU(int value)
{
    /// TODO: your code here
}

void MainWindow::setV(int value)
{
    /// TODO: your code here
}

void MainWindow::setRingResolution(int value)
{
    /// TODO: your code here
}

void MainWindow::activateDeathStar(bool value)
{
    /// TODO: your code here

}

void MainWindow::activateDeathStarPreview(bool value)
{
    /// TODO: your code here
}

void MainWindow::setDeathStarLength(int value)
{
    /// TODO: your code here
}

void MainWindow::setDeathStarRadius(int value)
{
    /// TODO: your code here
}

void MainWindow::setPath(bool value)
{
    /// TODO: your code here
}

void MainWindow::setPlanet(QString value)
{
    /// TODO: your code here
}


/* Qt mouse and keyboard events */

void MainWindow::keyPressEvent(QKeyEvent* event)
{
    // enable control via keyboard
    switch (event->key()) {
    case Qt::Key_F:
        if (isFullScreen()) {
            showNormal();
        } else {
            showFullScreen();
        }
        break;
    case Qt::Key_Escape:
    case Qt::Key_Q:
        close();
        break;
    }
}


