#ifndef COORDINATESYSTEM_H
#define COORDINATESYSTEM_H

#include "planets/drawable.h"

class CoordinateSystem : public Drawable
{
public:
    CoordinateSystem();

    // Drawable interface
public:
    virtual void draw(glm::mat4 projection_matrix) const override;
    virtual void update(float elapsedTimeMs, glm::mat4 modelViewMatrix) override;

protected:
    virtual std::string getVertexShader() const;
    virtual std::string getFragmentShader() const;
    virtual void createObject();

    float _length;
};

#endif // COORDINATESYSTEM_H
