#ifndef DRAWABLE_H
#define DRAWABLE_H

#include <memory>
#include <vector>
#include <string>

#define GLM_FORCE_RADIANS

#include <glm/vec3.hpp>
#include <glm/mat4x4.hpp>
#include <glm/gtc/quaternion.hpp>

#ifdef _WIN32
#include <windows.h>
#endif

#include <GL/gl.h>

class Cone;
class Sun;

class Drawable{

public:

    Drawable(std::string name = "UNNAMED");

    virtual void init();

    virtual void recreate();

    // draw the object
    // (const because draw should not alter the object)
    virtual void draw(glm::mat4 projection_matrix) const = 0;

    // update position, rotation etc.
    virtual void update(float elapsedTimeMs, glm::mat4 modelViewMatrix) = 0;

protected:

    std::string _name;

    GLuint _program;
    GLuint _vertexArrayObject;
    glm::mat4 _modelViewMatrix;

    virtual void initShader();
    virtual std::string loadShaderFile(std::string path) const;

    virtual GLuint loadTexture(std::string path);

    virtual std::string getVertexShader() const = 0;
    virtual std::string getFragmentShader() const = 0;

    virtual void createObject() = 0;
};


#endif // DRAWABLE_H

