#ifndef DYSONSEG_H
#define DYSONSEG_H

#include "drawable.h"

#include <memory>

#include <glm/vec3.hpp>
#include <glm/mat4x4.hpp>
#include <glm/gtc/quaternion.hpp>

//#include <GL/gl.h>

#include <QOpenGLTexture>

class Orbit;
class Path;
class Sun;
class Cone;

class DysonSegment : public Drawable
{
public:
    DysonSegment(
            int number = 0,
            int swarm = 0,
            float radius = 1.f,
            std::shared_ptr<Sun> = NULL
            );

    virtual void init() override;

    virtual void draw(glm::mat4 projection_matrix) const override;

    virtual void update(float elapsedTimeMs, glm::mat4 modelViewMatrix) override;

    virtual void setLights(std::shared_ptr<Sun> sun, std::shared_ptr<Cone> laser);

    // add a child to the hierarchy

    ~DysonSegment();


protected:

    unsigned int _numVertices;

    float _radius;

    GLuint _texture;
    std::string _textureLocation;

    std::shared_ptr<Sun> _sun;

    virtual void createObject() override;

    virtual std::string getVertexShader() const override;
    virtual std::string getFragmentShader() const override;

    virtual void beforeDraw() const {}
    virtual void afterDraw() const {}

};

#endif // DYSONSEG_H
