#include <GL/glew.h>
#include "dysonswarm.h"


#define GLM_FORCE_RADIANS
#define GLM_SWIZZLE
#include <glm/glm.hpp>
#include <glm/gtc/constants.hpp>
#include <glm/gtx/transform.hpp>
#include <glm/gtc/type_ptr.hpp>
#include <glm/gtx/perpendicular.hpp>

#include <vector>
#include <stack>
#include <iostream>
#include <memory>

#include <QImage>
#include <QOpenGLTexture>
#include <QString>
#include <QFile>
#include <QTextStream>

#include "glbase/gltool.hpp"

//using namespace glm;

#include "gui/config.h"

#include "planets/cone.h"
#include "planets/sun.h"
#include "planets/orbit.h"
#include "planets/path.h"

#include "image/image.h"

DysonSwarm::DysonSwarm(float rotation, int number, float radius, float distance, float hoursPerDay, unsigned int daysPerYear, std::shared_ptr<Sun> Sun):
    _radius(radius),
    _distance(distance),
    _localRotation(0),
    _localRotationSpeed(0),
    _daysPerYear(daysPerYear),
    _globalRotation(0),
    _globalRotationSpeed(0)
{
    _globalRotationSpeed = 1.0f / (daysPerYear);        // one step equals one day
    _localRotation=rotation;

    _globalRotation = number*5;
    _sun = Sun;
    for(int i=0; i<32; i++)
        _segments.push_back(DysonSegment(i,0,radius,Sun));
}

void DysonSwarm::init()
{
    /// TODO your code here
}

void DysonSwarm::draw(glm::mat4 projection_matrix) const
{
    /// TODO your code here
}

void DysonSwarm::update(float elapsedTimeMs, glm::mat4 modelViewMatrix)
{
    /// TODO your code here
}

void DysonSwarm::setLights(std::shared_ptr<Sun> sun, std::shared_ptr<Cone> laser)
{
    /// TODO your code here
}


DysonSwarm::~DysonSwarm(){

}
