#ifndef DYSONSWARM_H
#define DYSONSWARM_H

#include <memory>

#include <glm/vec3.hpp>
#include <glm/mat4x4.hpp>
#include <glm/gtc/quaternion.hpp>

//#include <GL/gl.h>

#include <QOpenGLTexture>
#include "planets/dysonsegment.h"

class Orbit;
class Path;
class Sun;
class Cone;

class DysonSwarm
{
public:
    DysonSwarm(
            float rotation = 45.f,
            int number = 0,
            float radius = 1.0f,
            float distance = 10.0f,
            float hoursPerDay = 24.0f,
            unsigned int daysPerYear = 365,
            std::shared_ptr<Sun> = NULL
            );

    virtual void init();


    virtual void draw(glm::mat4 projection_matrix) const;

    virtual void update(float elapsedTimeMs, glm::mat4 modelViewMatrix);

    virtual void setLights(std::shared_ptr<Sun> sun, std::shared_ptr<Cone> laser);

    // add a child to the hierarchy

    ~DysonSwarm();


protected:

    std::vector<DysonSegment> _segments;

    unsigned int _numVertices;

    float _radius;

    float _distance;

    float _localRotation;
    float _localRotationSpeed;

    unsigned int _daysPerYear;
    float _globalRotation;
    float _globalRotationSpeed;

    std::shared_ptr<Sun> _sun;


    virtual void beforeDraw() const {}
    virtual void afterDraw() const {}
};

#endif // DYSONSWARM_H
