#ifndef EARTH_H
#define EARTH_H

#include "planets/planet.h"

class Earth : public Planet
{
public:
    Earth(std::string name = "UNNAMED EARTH",
          float radius = 1.0f,
          float distance = 0.0f,
          float hoursPerDay = -0.01f,
          float daysPerYear = 0.0f,
          std::string textureLocation = ":/res/images/earth.bmp"
          );

    virtual void init() override;

    virtual std::string getFragmentShader() const override;

    virtual void beforeDraw() const override;

    virtual void update(float elapsedTimeMs, glm::mat4 modelViewMatrix) override;

private:
    GLuint _cloudTexture;
    float _cloudRotation;
    float _cloudRotationSpeed;

};

#endif // EARTH_H
