#ifndef PATH_H
#define PATH_H

#include "planets/orbit.h"

#include <vector>

#include <glm/vec3.hpp>

class Path : public Orbit
{
public:
    Path(std::string name = "UNKNOWN PATH");

public:
    virtual void addPosition(glm::vec3 position);

    virtual void createObject() override;

    virtual void draw(glm::mat4 projection_matrix) const override;


    static void setModelViewMatrix(glm::mat4 modelViewMatrix);

protected:

    static glm::mat4 _modelViewMatrix;

    std::vector<glm::vec3> _positions;

};

#endif // PATH_H
