#ifndef PLANET_H
#define PLANET_H

#include "planets/drawable.h"

#include <memory>

#include <glm/vec3.hpp>
#include <glm/mat4x4.hpp>
#include <glm/gtc/quaternion.hpp>

//#include <GL/gl.h>

#include <QOpenGLTexture>

class Orbit;
class Path;
class Sun;
class Cone;

class Planet : public Drawable
{
public:
    Planet(std::string name = "UNNAMED PLANET",
            float radius = 1.0f,
            float distance = 10.0f,
            float hoursPerDay = 24.0f,
            unsigned int daysPerYear = 365,
            std::string textureLocation = ":/res/images/earth.bmp"
            );

    virtual void init() override;

    virtual void calculatePath(glm::mat4 modelViewMatrix);

    virtual void recreate() override;

    virtual void draw(glm::mat4 projection_matrix) const override;

    virtual void update(float elapsedTimeMs, glm::mat4 modelViewMatrix) override;

    virtual void updatePath(float elapsedTimeMs, glm::mat4 modelViewMatrix);

    virtual void setLights(std::shared_ptr<Sun> sun, std::shared_ptr<Cone> laser);

    virtual std::vector<std::string> getNames();

    // add a child to the hierarchy
    virtual void addChild(std::shared_ptr<Planet> child);

    ~Planet();


protected:

    std::vector<std::shared_ptr<Planet>> _children;

    unsigned int _numVertices;

    float _radius;

    float _distance;

    float _localRotation;
    float _localRotationSpeed;

    unsigned int _daysPerYear;
    float _globalRotation;
    float _globalRotationSpeed;

    GLuint _texture;
    std::string _textureLocation;

    std::shared_ptr<Orbit> _orbit;
    std::shared_ptr<Path> _path;

    std::shared_ptr<Sun> _sun;
    std::shared_ptr<Cone> _laser;

    virtual void createObject() override;

    virtual std::string getVertexShader() const override;
    virtual std::string getFragmentShader() const override;

    virtual void beforeDraw() const {}
    virtual void afterDraw() const {}

    unsigned int getKGV(unsigned int other);
    unsigned int greatestCommonDivisor(unsigned int a, unsigned int b);

    virtual std::shared_ptr<Path> getPath() const;
    virtual void addPathPoint();
    virtual void createPath();
};

#endif // PLANET_H
