#ifndef RING_H
#define RING_H

#include "planets/drawable.h"

class Ring : public Drawable
{
public:
    Ring(
            std::string name = "UNKNOWN RING",
            float innerRadius = 1.0f,
            float outerRadius = 2.0f,
            float rotationSpeed = -0.01f,
            glm::vec3 rotationAxis = glm::vec3(0.0f, 1.0f, 0.0f),
            std::string texturePath = ":/res/images/ring.bmp"
    );

    // Drawable interface
public:
    virtual void draw(glm::mat4 projection_matrix) const override;
    virtual void update(float elapsedTimeMs, glm::mat4 modelViewMatrix) override;

    virtual void init() override;

protected:

    float _innerRadius, _outerRadius;

    glm::vec3 _rotationAxis;
    float _rotationSpeed;
    float _localRotation;

    float _numVertices;

    GLuint _texture;
    std::string _texturePath;

    virtual std::string getVertexShader() const;
    virtual std::string getFragmentShader() const;
    virtual void createObject();
};

#endif // RING_H
