#include "saturn.h"

#include "planets/ring.h"

Saturn::Saturn(std::string name, float radius, float distance, float hoursPerDay, unsigned int daysPerYear, std::string textureLocation):
    Planet(name, radius, distance, hoursPerDay, daysPerYear, textureLocation)
{
    _ring = std::make_shared<Ring>("Saturn Ring", 0.5f, 1.0f);
}



void Saturn::init()
{
    Planet::init();
    _ring->init();
}

void Saturn::recreate()
{
    Planet::recreate();
    _ring->recreate();
}

void Saturn::draw(glm::mat4 projection_matrix) const
{
    Planet::draw(projection_matrix);
    _ring->draw(projection_matrix);
}

void Saturn::update(float elapsedTimeMs, glm::mat4 modelViewMatrix)
{
    Planet::update(elapsedTimeMs, modelViewMatrix);
    _ring->update(elapsedTimeMs, _modelViewMatrix);
}

void Saturn::createObject()
{
    Planet::createObject();
    _ring->recreate();
}
