#ifndef SATURN_H
#define SATURN_H

#include "planets/planet.h"

class Ring;

class Saturn : public Planet
{
public:
    Saturn(std::string name = "UNNAMED SATURN",
           float radius = 1.0f,
           float distance = 10.0f,
           float hoursPerDay = 24.0f,
           unsigned int daysPerYear = 366,
           std::string textureLocation = ":/res/images/saturn.bmp");

    // Drawable interface
public:
    virtual void init() override;
    virtual void recreate() override;
    virtual void draw(glm::mat4 projection_matrix) const override;
    virtual void update(float elapsedTimeMs, glm::mat4 modelViewMatrix) override;

protected:
    virtual void createObject() override;

    std::shared_ptr<Ring> _ring;
};

#endif // SATURN_H
