#ifndef SKYBOX_H
#define SKYBOX_H

#include "planets/drawable.h"

//#include <GL/gl.h>

class Skybox : public Drawable
{
public:
    Skybox();

    virtual void init() override;

    virtual void recreate() override {}

    virtual void draw(glm::mat4 projection_matrix) const override;

    virtual void update(float elapsedTimeMs, glm::mat4 modelViewMatrix) override;

protected:

    GLuint _texture;

    virtual std::string getVertexShader() const override;
    virtual std::string getFragmentShader() const override;

    virtual void loadTexture();
    virtual void createObject() override;
};

#endif // SKYBOX_H
