#include <GL/glew.h>

#include "sun.h"

#define GLM_FORCE_RADIANS
#define GLM_SWIZZLE
#include <glm/glm.hpp>
#include <glm/gtc/constants.hpp>
#include <glm/gtx/transform.hpp>
#include <glm/gtc/type_ptr.hpp>
#include <glm/gtx/perpendicular.hpp>

#include <stack>
#include <iostream>

#include "glbase/gltool.hpp"
#include "planets/path.h"

Sun::Sun(std::string name, float radius, float distance, float hoursPerDay, float daysPerYear, std::string textureLocation):
    Planet(name, radius, distance, hoursPerDay, daysPerYear, textureLocation)
{

}

void Sun::init()
{
    Planet::init();
}
void Sun::beforeDraw() const
{
    glUniform1i(glGetUniformLocation(_program, "lighting"), false);
}


glm::vec3 Sun::getPosition() const
{
    /// TODO: return the position of the sun in model view coordinates

    // Hint: the model view matrix is part of the super class

    return glm::vec3();
}

void Sun::update(float elapsedTimeMs, glm::mat4 modelViewMatrix)
{
    Planet::update(elapsedTimeMs, modelViewMatrix);

    Path::setModelViewMatrix(modelViewMatrix);
}
