#ifndef SUN_H
#define SUN_H

#include <glm/vec3.hpp>

#include <memory>

#include "planets/planet.h"

class Sun : public Planet
{
public:
    Sun(std::string name = "Sun",
        float radius = 1.f,
        float distance = 1.f,
        float hoursPerDay = 250.f,
        float daysPerYear = 365.f,
        std::string textureLocation = ":/res/images/sun.bmp");

    virtual void init() override;

    glm::vec3 getPosition() const;

    virtual void update(float elapsedTimeMs, glm::mat4 modelViewMatrix) override;

protected:
    virtual void beforeDraw() const override;

};

#endif // SUN_H
