/*
 * Copyright (C) 2014
 * Computer Graphics Group, University of Siegen
 * Written by Martin Lambers <martin.lambers@uni-siegen.de>
 * All rights reserved.
 */

#ifndef GLWIDGET_H
#define GLWIDGET_H

#include <cstdio>
#include <cstdlib>

#include <GL/glew.h>

#include <QGLWidget>
#include <QMessageBox>
#include <QTimer>
#include <QKeyEvent>

#define GLM_FORCE_RADIANS
#include <glm/gtc/type_ptr.hpp>

class GLWidget : public QGLWidget
{
    Q_OBJECT

public:
    static void setGLFormat(QGL::FormatOptions format)
    {
        QGLFormat qglFormat(format);
        qglFormat.setSwapInterval(::getenv("COREGL_FPS") ? 0 : 1);
        qglFormat.setVersion(4, 0);
        qglFormat.setProfile(QGLFormat::CoreProfile);
        QGLFormat::setDefaultFormat(qglFormat);
    }

    GLWidget() : QGLWidget(static_cast<QWidget*>(0)), prg(0), vao(0), angle(0)
    {
        if (!context()->isValid() || (context()->format().majorVersion() != 4 && context()->format().majorVersion() != 3)) {
            QMessageBox::critical(this, "Error", "Cannot get a valid OpenGL 3/4 context.");
            exit(1);
        }
    }

    virtual ~GLWidget() {}

    virtual void initializeGL();
    virtual void resizeGL(int width, int height);
    virtual void paintGL();

public slots:
    void animateGL();

protected:
    void keyPressEvent(QKeyEvent* event)
    {
        static bool fullscreen = false;
        switch (event->key()) {
        case Qt::Key_F:
            if (fullscreen) {
                showNormal();
                fullscreen = false;
            } else {
                showFullScreen();
                fullscreen = true;
            }
            break;
        case Qt::Key_Escape:
        case Qt::Key_Q:
            close();
            break;
        }
    }

    //virtual void mousePressEvent(QMouseEvent* event);
    //virtual void mouseMoveEvent(QMouseEvent* event);
    //virtual void wheelEvent(QWheelEvent* event);

    // void initializeBuffers();
    //glm::vec3* setupStar(float d);


    void initializeBuffers(glm::vec3* geometry, int length);
    void setupStar(float d, glm::vec3** star, int &length);

    GLuint prg;
    GLuint vao;

    float angle;
};

#endif
