%%
% The function for performing an adaptive dither operations on an image 

function [ ditheredImage ] = FS_ImageDithering( bwImage, threshold )

[row,col] = size(bwImage);
I = bwImage;
error = zeros(row, col);
ditheredImage = zeros (row, col);

for i = 1: row
    for j = 1: col
   
        if (I(i, j) >= threshold)
        
        ditheredImage(i, j) = 255;
        else
            ditheredImage(i, j)=0;
            
        end
        error (i, j) = ditheredImage(i, j) - I(i, j);
        
        if (j< col)
            ditheredImage(i, j+1) = ditheredImage(i, j+1) + (7/16) * error(i, j);
        end
        
        if (i < row && j > 1)
            ditheredImage(i+1, j-1) = ditheredImage(i+1, j-1) + (3/16) * error(i, j);
        end
        
        if (i < row)
            ditheredImage(i+1, j) = ditheredImage(i+1, j) + (5/16) * error(i, j);
        end
        
        if (i < row && j < col)
            ditheredImage(i+1, j+1) = ditheredImage(i+1, j+1) + (1/16) * error(i, j);
        end
             
    end
end

end

