%%
% Ex1. Reading and rganizing the Dermoscopic image
%data set and performing Floyd-Steinberg dithering
clear
srcFolder = 'C:\Users\Amir\Documents\documents\course\MEdIPExercise\PH2Dataset\PH2Dataset\PH2 Dataset images';

mkdir ('RawImages');
mkdir ('DitheredImages');

contents = dir(srcFolder);
subFolders = contents ([contents.isdir]);

for i=1:length(subFolders)-2
   
    filename = fullfile(srcFolder, subFolders(i+2).name, strcat(subFolders(i+2).name,'_Dermoscopic_Image','\',subFolders(i+2).name,'.bmp'));
    rawImage = imread(filename);
    
    bwImage = rgb2gray(rawImage);
    
    savedRawImage = sprintf(subFolders(i+2).name);
    fullSavedRawImage = fullfile(strcat('RawImages','\',savedRawImage,'.bmp'));
    
    imwrite (rawImage, fullSavedRawImage);
    
    ditheredImage = FS_ImageDithering(bwImage, 184);
    %figure; imshow(ditheredImage);
    
    savedDitheredImage = sprintf(subFolders(i+2).name);
    fullSavedDitheredImage = fullfile(strcat('DitheredImages','\',savedDitheredImage,'.bmp'));
    
    imwrite(ditheredImage, fullSavedDitheredImage);
    
    
    
    
    
    
end



%%

%%