function [Noten,moeglicheNoten] =PunkteZuNoten(Punkte,PMax,Note1,Note4)
%% Berechnet die Punkte fr Noten

% Mgliche Noten
moeglicheNoten = [1.0; 1.3; 1.7; 2.0; 2.3; 2.7; 3.0; 3.3; 3.7; 4.0];

% lineare Regression durch 2 Punkte:
% 1: Note 1,0 bei Punkte Note1*Pmax
% 2: Note 4,0 bei Punkte Note4*Pmax
P=polyfit([1.0 4.0],[Note1*PMax Note4*PMax],1);

% Auswerten des Polynoms fr alle Noten
abPunkte=round(polyval(P,moeglicheNoten));

% nicht bestanden hinzufgen, ab 0 Punkte
moeglicheNoten = [moeglicheNoten; 5.0];
abPunkte = [abPunkte; 0];

% Den Punkten eine Note zuordnen
% Anzahl der Noten = Anzahl der Punkte
Noten=zeros(size(Punkte));

% Schleife ber alle Punkte
for i = 1:length(Punkte)
    %% Diese Schleife entspricht der Excel-Funktion SVERWEIS
    
    % Index in "abPunkte" finden, wo das erste mal (first) die gegebenen
    % Punkte kleiner gleich sind.
    wo=find(abPunkte<=Punkte(i),1,'first');
    
    % Die Note raussuchen und im Noten-Vektor zuordnen
    Noten(i)=moeglicheNoten(wo);
end
end