
n = 8; %numer of relevant frequences


s = 100; %numer of samples - 1

x = [-pi : 2*pi/s : pi];   %time domain
f = x.^2;                   %function x^2 in defined in the time domain


%initialise the amplitudes
a = zeros(1,n);

for w=1:n    %amplitudes
    a(w)=(4./(w.^2)).*(-1).^w;
end


a(2) = 0;

%initialise the trigonometric part
trigo = zeros(n,s+1);

for w=1:n
   trigo(w,:) = cos(w*x);
end

%initialise the approximation function
af = zeros(1,s+1);

for w=1:n
   af = af + a(w)*trigo(w,:); 
end

%a_0 has to be added to the function
af = af + (1/3)*pi^2;


plot(x,f)
hold all
plot(x,af)



