
Fs = 1000;                    % Sampling frequency
T = 1/Fs;                     % Sample time
L = 1000;                     % Length of signal
t = (0:L-1)*T;                % Time vector

%x = t.^2;

% Sum of a 50 Hz sinusoid and a 120 Hz sinusoid
%x = 0.7*sin(2*pi*50*t) + sin(2*pi*120*t); 

Fs = 100;
T  = 1/Fs;
t  = [-pi:T:pi];

x = t.^2 + (t-1515).^3


%original signal
%plot(Fs*t(1:50),x(1:50))
%title('Original Signal')
%xlabel('time (milliseconds)')



%y = x + 2*randn(size(t));     % Sinusoids plus noise

y = x;

%signal with noise added
%plot(Fs*t(1:50),y(1:50))
%title('Signal Corrupted with Zero-Mean Random Noise')
%xlabel('time (milliseconds)')


NFFT = 2^nextpow2(L); % Next power of 2 from length of y
Y = fft(y,NFFT)/L;
f = Fs/2*linspace(0,1,NFFT/2+1);

% Plot single-sided amplitude spectrum.
plot(f,2*abs(Y(1:NFFT/2+1))) 
title('Single-Sided Amplitude Spectrum of y(t)')
xlabel('Frequency (Hz)')
ylabel('|Y(f)|')