function varargout = cad_guide(varargin)
% CAD_GUIDE MATLAB code for cad_guide.fig
%      CAD_GUIDE, by itself, creates a new CAD_GUIDE or raises the existing
%      singleton*.
%
%      H = CAD_GUIDE returns the handle to a new CAD_GUIDE or the handle to
%      the existing singleton*.
%
%      CAD_GUIDE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in CAD_GUIDE.M with the given input arguments.
%
%      CAD_GUIDE('Property','Value',...) creates a new CAD_GUIDE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before cad_guide_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to cad_guide_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help cad_guide

% Last Modified by GUIDE v2.5 24-Oct-2013 15:24:15

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @cad_guide_OpeningFcn, ...
                   'gui_OutputFcn',  @cad_guide_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before cad_guide is made visible.
function cad_guide_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to cad_guide (see VARARGIN)

% Choose default command line output for cad_guide
handles.output = hObject;
handles.path = 'C:\Users\joanna\Documents\AAAData_PrePost_zip\NEW\10000\DICOM\256732_ANONYMO\12710952\7';
handles.img=[];
handles.pinfo=[];
axes(handles.axes_input);
axis off
axes(handles.axes_output);
axis off
% Update handles structure
guidata(hObject, handles);

% UIWAIT makes cad_guide wait for user response (see UIRESUME)
% uiwait(handles.gui);


% --- Outputs from this function are returned to the command line.
function varargout = cad_guide_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in read.
function read_Callback(hObject, eventdata, handles)
% hObject    handle to read (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles = guidata(findobj('Tag','gui'));

% clear the axes if its necesary
cla(handles.axes_input);
cla(handles.axes_output);


% av_files = dir(fullfile(path,'*.dcm'));
% read DICOM image
[file, path]=uigetfile('*.dcm*','Select the file to read');
img=dicomread(fullfile(path,file));
pinfo=dicominfo(fullfile(path,file));
axes(handles.axes_input);
imshow(img, []);
handles.img=img;
handles.pinfo=pinfo;

% update the info in the panel
set(handles.nameedt,'String',pinfo.PatientName.FamilyName);
set(handles.ageedt,'String',pinfo.PatientAge);
set(handles.protedt,'String',pinfo.SeriesDescription);
set(handles.run,'Enable','on');
set(handles.thresholding,'Enable','on');
set(handles.tr,'Enable','on');
set(handles.trlist,'Enable','on');

% set the slider
set(handles.tr,'Value',0.5);
mx=max(img(:));
set(handles.trstring,'String',num2str(mx*0.5));

guidata(hObject, handles);

% --- Executes on button press in thresholding.
function thresholding_Callback(hObject, eventdata, handles)
% hObject    handle to thresholding (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles = guidata(findobj('Tag','gui'));
pos=get(findobj('Tag','tr'),'Value');
tr=max(handles.img(:))*pos;
trmask=handles.img;
trmask(trmask<=tr)=0;
axes(handles.axes_output);
imshow(trmask,[]);

handles.trmask=trmask;
guidata(hObject, handles);

% --- Executes on slider movement.
function tr_Callback(hObject, eventdata, handles)
% hObject    handle to tr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
handles = guidata(findobj('Tag','gui'));
pos=get(findobj('Tag','tr'),'Value');
tr=max(handles.img(:))*pos;
trmask=handles.img;
trmask(trmask<=tr)=0;
axes(handles.axes_output);
imshow(trmask,[]);
handles.trmask=trmask;

% change the string
set(handles.trstring,'String',num2str(tr));
guidata(hObject, handles);

% --- Executes on selection change in trlist.
function trlist_Callback(hObject, eventdata, handles)
% hObject    handle to trlist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns trlist contents as cell array
%        contents{get(hObject,'Value')} returns selected item from trlist
handles = guidata(findobj('Tag','gui'));
pos = get(hObject,'Value');
switch pos
    case 1
        tr=max(handles.img(:))*0.25;
    case 2
        tr=max(handles.img(:))*0.5;
    case 3
        tr=max(handles.img(:))*0.75;
end
trmask=handles.img;
trmask(trmask<=tr)=0;
axes(handles.axes_output);
imshow(trmask,[]);
handles.trmask=trmask;
guidata(hObject, handles);

% --- Executes on button press in run.
function run_Callback(hObject, eventdata, handles)
% hObject    handle to run (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object creation, after setting all properties.
function pinfo_CreateFcn(hObject, eventdata, handles)
% hObject    handle to pinfo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes during object creation, after setting all properties.
function nameedt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to nameedt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes during object creation, after setting all properties.
function ageedt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ageedt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes during object creation, after setting all properties.
function protedt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to protedt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called


% --- Executes during object creation, after setting all properties.
function tr_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes during object creation, after setting all properties.
function trlist_CreateFcn(hObject, eventdata, handles)
% hObject    handle to trlist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
