% function mathematical_morphology

close all;
clear all;
clc;
addpath('C:\Users\joanna\Documents\IMG_PROC\matlab.contrib');
% path = 'C:\Users\joanna\Documents\AAAData_PrePost_zip\NEW\10000\DICOM\256732_ANONYMO\12710952\7';
path='C:\Users\joanna\Documents\AAAData_PrePost_zip\NEW\10000\DICOM\178281_ANONYMO\12700304\4';
% find all the files in it
av_files = dir(fullfile(path,'*.dcm'));

% put all the files into one series
%%
img=[];
for k=2:20 %size(av_files,1)
    name = av_files(k,1).name;
    X = dicomread(fullfile(path,name));
    img=cat(3,img,X);
end

figure; imshow(img(:,:,10),[]);
Y = dicominfo(fullfile(path,av_files(1,1).name));

%% Operations on the masks
%% Segment all the objects being in the brightest group in the image
% prepare the data for the analysis
% data=double(reshape(img,[],1)); % each row in the data is the sample data point, features are given in columns
% cluster_n = 4; % the number of clusters
% [center,U,obj_fcn] = fcm(data,cluster_n); 
% 
% % analyze the obtained results
% [~,kl]=max(U);
% img_kl=reshape(kl,size(img));
% figure; imshow(img_kl(:,:,14),[]);
% 
% % find the group with the maximal intensity value
% lab=find(center==max(center(:)));
% img_kl(img_kl~=lab)=0;
% img_kl(img_kl~=0)=1;
% figure; imshow(img_kl(:,:,14),[]);

%% to get the results faster.....
tr = 0.26*max(img(:));
img_tmp=img;
img_tmp(img<tr)=0;
img_tmp(img_tmp~=0)=1;
img_kl=img_tmp;
figure; imshow(img_kl(:,:,14),[]);
%% Perform the morphological erosion on a single slice
im_temp=img_kl(:,:,14);
se = strel('disk',1); % structural element       
im_er=imerode(im_temp,se);
figure; subplot(1,2,1); imshow(im_temp,[]); subplot(1,2,2); imshow(im_er,[]);

% indicate the object
[y,x]=ginput(1);
x=round(x);
y=round(y);
bl=bwlabel(im_er,8);
lab=bl(x,y);
bl(bl~=lab)=0;
bl(bl==lab)=1;

%% Perform the morphological dilation
im_dl=imdilate(bl,se);
figure; subplot(1,3,1); imshow(im_temp,[]); subplot(1,3,2); imshow(im_er,[]); subplot(1,3,3); imshow(im_dl,[])

% 1. Test the usage of different structural elements
% .............. %

%% Fill the holes in the image
im_fill = imfill(im_temp,'holes');
figure; subplot(1,2,1); imshow(im_temp,[]); subplot(1,2,2); imshow(im_fill,[]);
% perform the erode
se=[0 1 0;1 1 1;0 1 0];
im_fer = imerode(im_fill,se);
figure; subplot(1,2,1); imshow(im_fill,[]); subplot(1,2,2); imshow(im_fer,[]);

% 2. Implement the image filling procedure based on labeling only 
% ............... %

%% perform labeling
bl=bwlabel(im_fer,8);
lab=bl(x,y);
bl(bl~=lab)=0;
bl(bl==lab)=1;

% perform dilation
im_dl=imdilate(bl,se);
figure; subplot(1,3,1); imshow(im_fill,[]); subplot(1,3,2); imshow(im_fer,[]); subplot(1,3,3); imshow(im_dl,[]);

%% Perform the 3-D erosion
% create the 3-D structural element
se3(:,:,1)=[0 0 0;0 1 0;0 0 0];
se3(:,:,2)=[0 1 0;1 1 1;0 1 0];
se3(:,:,3)=[0 0 0;0 1 0;0 0 0];

im_er3=imerode(img_kl,se3);
figure; subplot(1,3,1); imshow(im_er,[]); subplot(1,3,2); imshow(im_er3(:,:,14),[]); subplot(1,3,3); imshow(im_er-im_er3(:,:,14),[])

% 3. Adopt the filling procedure to 3-D, fill the holes and run 3-D
% erosion, labeling and dilation
% ............... %

%% Boundaries
% display the results of the segmetation using boundaries
[B,L] = bwboundaries(im_dl,'noholes');
figure; imshow(img(:,:,14),[]);

hold on
for k = 1:length(B)
    boundary = B{k};
    plot(boundary(:,2), boundary(:,1), 'r', 'LineWidth', 1)
end

%% Perform the morphological closing operation
se = ones(4,4);
im_cl = imclose(im_er,se);
figure; subplot(1,2,1); imshow(im_er,[]); subplot(1,2,2); imshow(im_cl,[]);

% 4. Check the influence of the structural element
% ................ %

% 5. Perform the closing operation using erosion and dilation with
% different structural elements
% ................ %

%% Perform the morphological opening operation
se = ones(4,4);
im_op = imopen(im_er,se);
figure; subplot(1,2,1); imshow(im_er,[]); subplot(1,2,2); imshow(im_op,[]);

%% Compare the results
figure; subplot(1,2,1); imshow(img(:,:,14),[]);
[B,L] = bwboundaries(im_cl,'noholes');
hold on
for k = 1:length(B)
    boundary = B{k};
    plot(boundary(:,2), boundary(:,1), 'r', 'LineWidth', 1)
end
hold off
subplot(1,2,2); imshow(img(:,:,14),[]);
[B,L] = bwboundaries(im_op,'noholes');
hold on
for k = 1:length(B)
    boundary = B{k};
    plot(boundary(:,2), boundary(:,1), 'r', 'LineWidth', 1)
end

%% Remove small objects
% clean the image removing the elements smaller than..
im_bop = bwareaopen(im_er, 10, 4);
figure; subplot(1,2,1); imshow(img(:,:,14),[]);
[B,L] = bwboundaries(im_er,'noholes');
hold on
for k = 1:length(B)
    boundary = B{k};
    plot(boundary(:,2), boundary(:,1), 'r', 'LineWidth', 1)
end
hold off
subplot(1,2,2); imshow(img(:,:,14),[]);
[B,L] = bwboundaries(im_bop,'noholes');
hold on
for k = 1:length(B)
    boundary = B{k};
    plot(boundary(:,2), boundary(:,1), 'r', 'LineWidth', 1)
end

%% Hit or Mis transformation
se1=[1 1 1 1 1;1 0 0 0 1;1 0 0 0 1;1 0 0 0 1;1 1 1 1 1];
se2=[0 0 0; 0 1 1; 0 1 1];
hmt=imerode(double(im_er),se2).*imerode(~double(im_er),se1);
figure; subplot(1,2,1); imshow(im_er,[]); subplot(1,2,2); imshow(hmt,[]);

%% Distance transform
% find the central point in the aorta
bd=bwdist(im_dl);
figure; subplot(1,2,1); imshow(bd,[]);
bd=bwdist(~im_dl);
subplot(1,2,2); imshow(bd,[]);
%% indicate the central point
f=find(bd==max(bd(:)));
mask_bd=zeros(size(bd));
mask_bd(f)=1;
se=ones(3);
mask_bd=imdilate(mask_bd,se);
% show the results
figure; imshow(img(:,:,14),[]);
[B,L] = bwboundaries(mask_bd,'noholes');
hold on
for k = 1:length(B)
    boundary = B{k};
    plot(boundary(:,2), boundary(:,1), 'r', 'LineWidth', 1)
end

%% Skeletonization
% find the skeleton of the aorta
path = 'C:\Users\joanna\Documents\AAAData_PrePost_zip\NEW\10000\DICOM\256732_ANONYMO\12710952\7';
av_files = dir(fullfile(path,'*.dcm'));
name = av_files(30,1).name;
img = dicomread(fullfile(path,name));
 
img_temp=img;
img_temp(img<1300)=0;
img_temp(img_temp~=0)=1;
figure; subplot(1,2,1); imshow(img,[]); subplot(1,2,2); imshow(img_temp,[]);
%% 
% select the object
figure; imshow(img_temp,[]);
[y,x]=ginput(1);
x=round(x);
y=round(y);
bl=bwlabel(img_temp,8);
lab=bl(x,y);
bl(bl~=lab)=0;
bl(bl~=0)=1;
bl_fill=imfill(bl,'holes');
figure; imshow(bl_fill,[]);
%% skeletonization
bl_sk = bwmorph(bl_fill,'skel',Inf);
figure; subplot(1,2,1); imshow(bl_fill,[]); subplot(1,2,2); imshow(bl_sk,[]);
%% boundaries
bl_bd = bwmorph(bl_fill,'remove');
figure; subplot(1,2,1); imshow(bl_fill,[]); subplot(1,2,2); imshow(bl_bd,[]);
%% conditional erosion
bl_ed = bwulterode(bl_fill);
bl_dst = bwdist(~bl_fill);
bl_max = imregionalmax(bl_dst);
figure; subplot(1,3,1); imshow(bl_ed,[]); subplot(1,3,2); imshow(bl_dst,[]); subplot(1,3,3); imshow(bl_max,[]);
