% function preprocessing
close all;
clear all;
clc;

%% read the data (the example from previous course)
path = 'C:\Users\joanna\Documents\AAAData_PrePost_zip\NEW\10000\DICOM\256732_ANONYMO\12710952\7';
% path='C:\Users\joanna\Documents\AAAData_PrePost_zip\NEW\10000\DICOM\178281_ANONYMO\12700304\4';
% find all the files in it
av_files = dir(fullfile(path,'*.dcm'));  

%% give stering to user and let him choose the number of slice to analyze
disp(['set the number of slice from ' num2str(1) ' to ' num2str(size(av_files,1)) ' and return: k=?; return']);
keyboard;

%% read the file and show the chosen slice
name=av_files(k,1).name; % the name of the chosen file
img=dicomread(fullfile(path,name)); % read the dicom file
figure; imshow(img,[]); % show the image

%% image adjustments
% used to increase the contrans within the certain range
ima = imadjust(img); % 1% of data is saturated at low and high intensities of img
figure; subplot(1,2,1); imshow(img,[]); subplot(1,2,2); imshow(ima,[]);

ima = imadjust(img,[0.01 0.095],[0.6 0.8]); % adjust so that, the values from a range [] are mapped into the range []
figure; subplot(1,2,1); imshow(img,[]); subplot(1,2,2); imshow(ima,[]);

%% gamma correction
gamma = 1.5;
ima = imadjust(img,[0 1],[0 1],gamma); % adjust so that, the values from a range [] are mapped into the range []
figure; subplot(1,2,1); imshow(img,[]); subplot(1,2,2); imshow(ima,[]);

%% histogram analysis
imhist(img);

%% histogram of the data
data = reshape(img,[],1);
hist(double(data),1000)
[col x]=hist(double(data),1000);

%% histogram equalization 
J = histeq(img,3000);
figure; subplot(1,2,1); imshow(J,[]); subplot(1,2,2); imhist(J)

%% thresholding
imgt = img;
imgt(img<=500)=0;
figure; imshow(imgt,[]);

%%
data = reshape(img,[],1);
figure; hist(double(data),1000); % choose the threshold based on the histogram 

keyboard;
disp('set the threshold: tr=?; return');
% tr=980; % based on the histogram anlysis
imgt = img;
imgt(img<=tr)=0;
figure; imshow(imgt,[]);

%% Otsu thresholding
imgnorm=double(img)/(max(double(img(:)))); 
figure; imshow(imgnorm,[]);

tr=graythresh(imgnorm);
imgtr = im2bw(imgnorm,tr).*imgnorm; 
figure; imshow(imgtr,[]);

%% Multi - thresholding
tr1 = 500; % air
tr2 = 700;
tr3 = 900;
tr4 = 1000;
tr5 = 1200;
imgtr=img;
imgtr(img<=tr1)=0;
imgtr(img>tr1&img<=tr2)=1;
imgtr(img>tr2&img<=tr3)=2;
imgtr(img>tr3&img<=tr4)=3;
imgtr(img>tr4&img<=tr5)=4;
imgtr(img>tr5)=5;
figure; imshow(imgtr,[]);
%% Exercise - use the histogram to create the multi-threshold values
% ..............
% ..............

%% Local thresholding
% divide the image into square
% br=[1;129;256;385]; % beginings of squares
% bk=[1 129 257 385];

nb=16;
step=round(size(img,1)/nb)-1;
bl=1:step:size(img,1)-step;
bll=0:1:nb-2;
bll=[0 bll];
br=(bl+bll)';
bk=(bl+bll);

br=repmat(br,[1 nb]);
bk=repmat(bk,[nb 1]);

er=(step+1)*ones(nb)+br;
ek=(step+1)*ones(nb)+bk;

imgtr=img;
l=1000;
for k=1:(nb*nb)
    imgtemp=img(br(k):er(k),bk(k):ek(k));
    tmin=min(imgtemp(:));
    tmax=max(imgtemp(:));
    tr=0.5*(tmin+tmax);
    c=tmax-tmin;
    if c>=l
        imgtemp(imgtemp<tr)=0;
    end
    imgtr(br(k):er(k),bk(k):ek(k))=imgtemp;
end
figure; imshow(imgtr,[]);

%% Filtering
% masks of filters
h = fspecial('average',5); % average filters
% h = fspecial('pill',3); % average filter circular
% h = fspecial('gaussian',5,0.5); % gaussian filter
imfil = filter2(h,img,'same'); % filtering procedure
figure; subplot(1,2,1); imshow(img,[]); subplot(1,2,2); imshow(imfil,[]);

imfil = medfilt2(img,[5 5]); % median filtering
figure; subplot(1,2,1); imshow(img,[]); subplot(1,2,2); imshow(imfil,[]);

[imfil,noise] = wiener2(img,[3 3]);  % Wiener filter
figure; subplot(1,2,1); imshow(img,[]); subplot(1,2,2); imshow(imfil,[]);

%% add some noise
J = imnoise(imgnorm,'gaussian',0,0.025); % gaussian noise
imfil = medfilt2(J,[5 5]); % median filtering
figure; subplot(1,2,1); imshow(J,[]); subplot(1,2,2); imshow(imfil,[]);

imfil = wiener2(J,[5 5]); % median filtering
figure; subplot(1,2,1); imshow(J,[]); subplot(1,2,2); imshow(imfil,[]);

%% 
J = imnoise(imgnorm,'salt & pepper',0.02); % salt & pepper noise
imfil = medfilt2(J,[5 5]); % median filtering
figure; subplot(1,2,1); imshow(J,[]); subplot(1,2,2); imshow(imfil,[]);

%% Edge detection
h = fspecial('prewitt'); % Prewitt filter
% h = fspecial(sobel); % sobel filter
% h = fspecial('laplacian'); % Laplace filter
imfil = filter2(h,img,'same'); % filtering procedure
figure; subplot(1,2,1); imshow(img,[]); subplot(1,2,2); imshow(imfil,[]);

%%
h = fspecial('sobel'); % sobel filter
% h = fspecial('laplacian'); % Laplace filter
imfil = filter2(h,img,'same'); % filtering procedure
figure; subplot(1,2,1); imshow(img,[]); subplot(1,2,2); imshow(imfil,[]);
%%
h = fspecial('sobel')';
imfil1 = filter2(h,img,'same'); % filtering procedure
figure; subplot(1,2,1); imshow(img,[]); subplot(1,2,2); imshow(imfil,[]);
%%
imfil = imfil+imfil1;
figure; subplot(1,2,1); imshow(img,[]); subplot(1,2,2); imshow(imfil,[]);
figure; imshow(abs(imfil),[]);
%%
h = fspecial('laplacian'); % Laplace filter
imfil = filter2(h,img,'same'); % filtering procedure
figure; subplot(1,2,1); imshow(img,[]); subplot(1,2,2); imshow(imfil,[]);