% function region_growing

close all;
clear all;
clc;
addpath('C:\Users\joanna\Documents\IMG_PROC\matlab.contrib');
% path = 'C:\Users\joanna\Documents\AAAData_PrePost_zip\NEW\10000\DICOM\256732_ANONYMO\12710952\7';
path='C:\Users\joanna\Documents\AAAData_PrePost_zip\NEW\10000\DICOM\178281_ANONYMO\12700304\4';
% find all the files in it
av_files = dir(fullfile(path,'*.dcm'));

% put all the files into one series
%%
img=[];
for k=1:size(av_files,1)
    name = av_files(k,1).name;
    X = dicomread(fullfile(path,name));
    img=cat(3,img,X);
end

figure; imshow(img(:,:,10),[]);
Y = dicominfo(fullfile(path,av_files(1,1).name));

%% Static approach (Matlab implementation)
% set the global criteria valid for the whole image

% indicate the object of interest
nr=10;
figure; imshow(img(:,:,nr),[]);
[y,x]=ginput(1); % mamualy select one pixel in the image [y,x] - position of the pixel

% check the gray intensity level of this pixel
gr = img(round(x),round(y),nr);

% global criteria
tr1 = gr-0.1*gr;
tr2 = gr+0.1*gr;

% perform the thresholding operation
data=zeros(size(img));
data(img>=tr1&img<=tr2)=1; 

figure; imshow(data(:,:,nr),[]);
%%
% perform the labeling procedure in 2-D
bl = bwlabeln(data(:,:,nr),8);
figure; imshow(bl,[]);
lab = bl(round(x),round(y));
bll = bl;
bll(bll~=lab)=0;
bll(bll~=0)=1;
figure; imshow(bll,[]);

% perform the labeling procedure - find the coherent objects in 3-D volume
bl = bwlabeln(data,6);
figure; imshow(bl(:,:,nr),[]);
lab = bl(round(x),round(y),nr);
bll = bl;
bll(bll~=lab)=0;
bll(bll~=0)=1;
figure; imshow(bll(:,:,nr),[]);

%%
% 1. Try to change the static criteria of the algorithm and check the
% obtained resutlts
% ................... %

% 2. Modify the neighborhood and check the results
% ................... %

%% visualize the 3D surface of the segmented object
% !!!!!!! to do his, please reduce the number of slice you use
figure;
pp = patch(isosurface(bll(:,:,1:10),0.1));
isonormals(bll(:,:,1:10),pp)
set(pp,'FaceColor','red','EdgeColor','none');
daspect([1,1,1])
view(3); axis tight
xlabel('x');
ylabel('y');
zlabel('z');
camlight 
lighting gouraud
%% Dynamic approach (Matlab implementation) - 2-D version
% get all the neighbours of all the pixels in image
im = img(:,:,nr);

% create the shifts for all the neighbours (4)
shifts = [0 1;0 -1;1 0;-1 0];
sh = [];

% create the shifts of the positions of all the neighbours :D
shx = [];
shy = [];
[Y,X]=meshgrid(1:size(im,1),1:size(im,2)); 

% use the Matlab shift trick
for k=1:length(shifts)
    cr = circshift(im,shifts(k,:));
    sh = cat(3,sh,cr);
    cr = circshift(X,shifts(k,:));
    shx = cat(3,shx,cr);
    cr = circshift(Y,shifts(k,:));
    shy = cat(3,shy,cr);
end

%%
% create a queue
qu = [round(x),round(y)]; % position of the first pixel analyzed

% create a mask of already analyzed pixels
ma = zeros(size(im));
ma(round(x),round(y))=1;

% create a resulting mask
msk = ma;
maxiter=100;
iter=0;
while ~isempty(qu)||iter<=maxiter
    % take the first point from the queue 
    p = qu(1,:);
    % remove the point form the queue
    qu(1,:)=[];
    % set the point as analyzed
    ma(p(1),p(2))=1;
    % check its neighbours - the set criterium
    nb = sh(p(1),p(2),:);
    nbx = shx(p(1),p(2),:);
    nby = shy(p(1),p(2),:);
    nbb = zeros(size(nb));
    nbb(nb>=tr1&nb<=tr2)=1; % test the criterium
    cox = reshape(nbx(nbb==1),[],1); % new coordinates added to the queue
    coy = reshape(nby(nbb==1),[],1);
    f=sub2ind(size(im),cox,coy);
    % check if the points were already analyzed
    fn=[];
    for k=1:length(f)
        if ma(f(k))~=1
            fn=[fn f(k)];
        end
    end
    % put the included points into the queue
    if ~isempty(fn) 
        msk(fn)=1;
        ma(fn)=1;
        [xx yy]=ind2sub(size(im),fn);
        qu=[qu;xx' yy'];
    end
    iter=iter+1;
end

% 1. Modify the criteria to make them dynamic (update them in each loop)
% ................... %

% 2. Modify the algorithm to 3-D version (at home)
% ................... %
