import numpy as np
import matplotlib.pyplot as plt
from PIL import Image
import scipy
from joblib import Parallel, delayed
import scipy.ndimage
from skimage import measure
import time


def erosion(img, kernel):
    image_padded = np.pad(img, 1)
    he,wi = image_padded.shape
    out = np.zeros(image_padded.shape)

    for row in range(1,he-1):
        for col in range(1,wi-1):
            sum_kernel = np.sum(image_padded[row-1:row+2,col-1:col+2]*kernel)
            if sum_kernel == np.sum(kernel):
                out[row,col] = 1
            else:
                out[row,col] = 0
    return out

def dilatation(img, kernel):
    image_padded = np.pad(img, 1)
    he,wi = image_padded.shape
    out = np.zeros(image_padded.shape)
    for row in range(1,he-1):
        for col in range(1,wi-1):
            sum_kernel = np.sum(image_padded[row-1:row+2,col-1:col+2]*kernel)
            if sum_kernel > 0:
                out[row,col] = 1
            else:
                out[row,col] = 0
    return out


def getLargestCC(segmentation):
    labels = measure.label(segmentation)
    assert(labels.max()!=0)
    largestCC = (labels == np.argmax(np.bincount(labels.flat)[1:])+1)
    return largestCC
    
    
def closing(img, kernel):
    print('Run Closing')
    return erosion(dilatation(img, kernel),kernel)

def opening(img, kernel):
    print('Run Opening')
    return dilatation(erosion(img, kernel),kernel)


def main():
    
    start_time = time.time()
    
    # Load Image
    img_dir = "box.jpg"
    img_pil = Image.open(img_dir).convert('L')
    img_pil = img_pil.resize([1036,691])
    img = np.array(img_pil)/255
    
    kernel_hori = [[0,0,0],[1,1,1],[0,0,0]]
    kernel_vert = [[0,1,0],[0,1,0],[0,1,0]]
    kernel_quad = [[1,1,1],[1,1,1],[1,1,1]]

    # Threshold
    img[img>0.5] = 1
    img[img<=0.5] = 0
    
    # Closing
    close1 = closing(img, kernel_vert)
    close2 = closing(close1, kernel_hori)
        
    # Fill holes
    filled = scipy.ndimage.morphology.binary_fill_holes(close2).astype(int)
    
    # Opening
    opened = opening(filled, kernel_quad)
    
    # Largest Cluster
    result = getLargestCC(opened)
    
    print("--- %s seconds ---" % (time.time() - start_time))
    
    # Plot 
    plt.figure(figsize=(10,15))
    sp1 = plt.subplot(121)
    sp1.imshow(np.rot90(result, 1), 'gray')
    sp2 = plt.subplot(122)
    sp2.imshow(np.rot90(np.array(img_pil)/255, 1), 'gray')
    plt.show()



if __name__ == "__main__":
    main()




        








