import matplotlib.pyplot as plt
import numpy as np
import cv2
from PIL import Image
from scipy import ndimage
from numpy import linalg as LA

def konstruiere_b(A,X):
    B1 = konstruiere_bi(np.append(A[:,0],[1]),np.append(X[:,0],[1]))
    B2 = konstruiere_bi(np.append(A[:,1],[1]),np.append(X[:,1],[1]))
    B3 = konstruiere_bi(np.append(A[:,2],[1]),np.append(X[:,2],[1]))
    B4 = konstruiere_bi(np.append(A[:,3],[1]),np.append(X[:,3],[1]))
    return np.vstack((B1,B2,B3,B4))

def konstruiere_bi(a,x):
    return np.hstack((a[0]*hut(x), a[1]*hut(x), a[2]*hut(x)))

def kleinster_ev(B):
    w, v = LA.eig(B)
    ind = np.argmin(w)
    return v[:,ind]

def hut(x):
    b = np.array([[0 , -x[2], x[1]],
              [x[2], 0, -x[0]],
              [-x[1], x[0],0]])
    return b

def main():
    # load image
    img = Image.open('giraffe.jpg').convert('L')
    
    # Coordinates
    A = np.array([[100,100,300,300],[100,300,100,300]], dtype=float)
    X = np.array([[100,100,290,300],[120,300,100,300]], dtype=float)

    # Calculate Transf. Matrix
    B = konstruiere_b(A,X)
    BtB = np.matmul(B.T,B);
    matrix_trans = kleinster_ev(BtB).reshape(3,3).T
    
    # Apply Transformation
    img = np.array(img)
    warped = cv2.warpPerspective(img, matrix_trans, (img.shape[1],img.shape[0]))

    # plot image
    imgplot = plt.imshow(warped, cmap=plt.get_cmap('gray'))
    plt.show()

    
if __name__ == "__main__":
    main()