import numpy as np
import matplotlib.pyplot as plt

def plotSignalAndFt(t,signal,fs):
    ''' Plots the input signal and the fourier transformed signal with respect to the time. 
          t: time
          signal: input signal
          fs: fourier transformed signal'''
    plt.figure(figsize=(16, 4))
    sp1 = plt.subplot(121)
    sp1.set_xlim(0,1)
    sp1.grid(True)
    sp1.set_xlabel('x')
    sp1.set_ylabel('Amplitude')
    sp1.set_title('Spacial Domain')
    sp1.plot(t,signal, 'bx--', markersize=6)
    
    sp2 = plt.subplot(122)
    sp2.set_xlabel('Fourier Transform')
    sp2.set_ylabel('Amplitude')
    sp2.set_title('Frequency Domain')
    sp2.grid(True)
    fftLength = np.array(fs.shape);
    sp2.set_xlim(0,fftLength-1)
    sp2.plot(np.arange(fftLength) ,abs(fs), 'bx', markersize=14)
    plt.show()
    
def fourier_transform(signal):
    len_array = len(signal)
    ind_res = np.arange(len_array)
    ind_array = ind_res.reshape((len_array, 1))
    res = np.exp(-2j * np.pi * ind_array * ind_res / len_array)
    fft = np.dot(res, signal)
    return fft
    
    
def main():
    
    # Create signal
    samples = 20
    t = np.arange(samples)/ samples
    signal = np.sin(2 * np.pi  * t)
    
    # Apply Fourier Transformation
    fs = fourier_transform(signal)
    
    # Plot Result
    plotSignalAndFt(t,signal,fs)
    
    # To check your code
    fs_np = np.fft.fft(signal)
    plotSignalAndFt(t,signal,fs_np)
    
    
if __name__ == "__main__":
    main()