import numpy as np
import matplotlib.pylab as plt
from PIL import Image


def apply_conv3x3(kernel, img):
    
    # Create Padded Image
    image_padded = np.zeros((img.shape[0] + 2, img.shape[1] + 2))
    out = np.zeros(image_padded.shape)
    he,wi = image_padded.shape
    
    # Add Padding
    for row in range(-1,img.shape[0] + 1):
        for col in range(-1,img.shape[1] + 1):
            image_padded[row+1,col+1] = img[np.mod(row,img.shape[0]), np.mod(col,img.shape[1])]
    
    # Show Padding
    plt.imshow(image_padded)
    plt.show()
    
    # Rotate Kernel
    kernel_r = np.rot90(kernel, 2)
    
    # Apply Convolution
    for row in range(1,he-1):
        for col in range(1,wi-1):
            out[row, col] = np.sum(image_padded[row-1:row+2,col-1:col+2]*kernel_r)

    return out[1:-1,1:-1]

def main():

    # Load Image
    img_dir="giraffe.jpg"
    img_pil=Image.open(img_dir).convert('L')
    img=np.array(img_pil)/255
    
    # Run Convolution
    alpha = 1
    kernel = np.array([[0, -alpha, 0], [-alpha, 4+alpha*4, -alpha], [0, -alpha, 0]])/4
    new_img = apply_conv3x3(kernel, img)
    new_img[new_img>1]=1
    new_img[new_img<0]=0
    
    # Plot Result
    plt.subplot(121)
    plt.imshow(img,'gray')
    plt.subplot(122)
    plt.imshow(new_img,'gray')
    plt.show()
   
if __name__ == "__main__": 
    main()