import numpy as np
import matplotlib.pylab as plt
from PIL import Image

def bilateralFilter(img_noisy, k, sigma_space, sigma_int):

    ny,nx = img_noisy.shape
    denoisedBilateral = img_noisy.copy()
    gaussKernel = np.exp(- sigma_space*np.arange(-k,k+1)**2)
    gaussKernel2d = np.outer(gaussKernel,gaussKernel)
    largeNoisyImg = np.pad(img_noisy, k, mode='edge')
    for i in range(k,ny+k):
        for j in range(k,nx+k):
            spacialFilter = np.zeros([2*k+1,2*k+1])
            for l in range(-k,k+1):
                for m in range(-k,k+1):
                    spacialFilter[l+k,m+k]= np.exp(-sigma_int*(largeNoisyImg[i+l,j+m]-largeNoisyImg[i,j])**2)
            filterKern = spacialFilter*gaussKernel2d
            filterKern = filterKern/np.sum(filterKern)
            val = 0.0
            for l in range(-k,k+1):
                for m in range(-k,k+1):
                    val = val+filterKern[l+k,m+k]*largeNoisyImg[i+l,j+m]
            denoisedBilateral[i-k,j-k] = val
    return denoisedBilateral    

def main():
    # load image
    img_dir = "statue.jpg"
    img_pil = Image.open(img_dir).convert('L')
    img = np.array(img_pil) / 255
    img_noisy = img + np.random.normal(0,0.05,img.shape)
    
    # apply filter
    w = 5
    sigma_space = .05
    sigma_int = 5
    new_img = bilateralFilter(img_noisy, w, sigma_space, sigma_int)

    # plot result
    plt.subplot(121)
    plt.imshow(img_noisy, 'gray')
    plt.subplot(122)
    plt.imshow(new_img, 'gray')
    plt.show()

if __name__ == "__main__": 
    main()
