### Lösung Blatt 9 ###

import numpy as np
import matplotlib.pyplot as plt
from PIL import Image
from skimage.util import view_as_blocks
from patchify import patchify, unpatchify

def dct(f):
    n = f.size
    c = np.zeros(n)
    c[0] = 1/np.sqrt(n)*np.sum(f)
    for k in range(1,n):
        c[k] = np.sqrt(2/n)*np.sum(f*np.cos(np.pi*k*(np.arange(n)+0.5)/n))
    return c

def idct(c):
    n = c.size
    f = np.zeros(n)
    for l in range(0,n):
        f[l] = np.sqrt(1/n)*c[0] + np.sqrt(2/n)*np.sum(c[1:n]*np.cos(np.pi*np.arange(1,n)*(l+0.5)/n))
    return f

def dct2(f):
    ny,nx = f.shape
    c = np.zeros([ny,nx])
    for s in range(ny):
        c[s,:] = dct(f[s,:])
    for t in range(nx):
        c[:,t] = dct(c[:,t])
    return c

def idct2(c):
    ny,nx = c.shape
    f = np.zeros([ny,nx])
    for s in range(ny):
        f[s,:] = idct(c[s,:])
    for t in range(nx):
        f[:,t] = idct(f[:,t])
    return f


def denoise_DCT(threshold, img):
    
    # Create Patches of size 16 x 16
    img_patch = patchify(img, [16,16])
    transf_img = 0*np.copy(img_patch)

    # On every Block: DCT2
    print('Start DCT')
    ny_blocks, nx_blocks, y_size_block, x_size_block = img_patch.shape
    for i in range(ny_blocks):
        for j in range(nx_blocks):
            transf_img[i,j] = dct2(img_patch[i,j])
        print(i)
    print('Finished DCT')

    transf_img[abs(transf_img)<threshold] = 0

    print('Start IDCT')
    idct_result = 0*np.copy(transf_img)
    ny_blocks_tr, nx_blocks_tr, y_size_block_tr, x_size_block_tr = transf_img.shape

    for i in range(ny_blocks_tr):
        for j in range(nx_blocks_tr):
            idct_result[i,j] = idct2(transf_img[i,j])  
        print(i)
    print('Finished IDCT')


    # Recreate Image from Patches
    img_denoised = unpatchify(idct_result, img.shape)

    return img_denoised
    
def bilateralFilter(img_noisy, k, sigma_space, sigma_int):

    ny,nx = img_noisy.shape
    denoisedBilateral = img_noisy.copy()
    
    # b) Erstellen Sie einen 2D-Gaußkern. Padden Sie das Eingabebild umkPixel aufjeder Seite
    gaussKernel = np.exp(- sigma_space*np.arange(-k,k+1)**2)
    gaussKernel2d = np.outer(gaussKernel,gaussKernel)
    largeNoisyImg = np.pad(img_noisy, k, mode='edge')
    
    # c) Schreiben Sie eine for-Schleife über alle ursprünglichen Pixel des Bildes
    # Dimensionen: largeNoisyImg: ny+10, nx+10
    for i in range(k,ny+k):
        for j in range(k,nx+k):

            # d) Extrahieren Sie an jedem Pixel einen(2k+ 1)×(2k+ 1)großen Patch, der den aktuellen Pixel als Zentrum hat.
            spacialFilter = np.zeros([2*k+1,2*k+1])
            for l in range(-k,k+1):
                for m in range(-k,k+1):
                
                    # e) Berechnen Sie für jeden Pixel in diesem Patch die Ähnlichkeit zum Mit-telpixel als in Form einer Exponentialfunktion.
                    spacialFilter[l+k,m+k]= np.exp(-sigma_int*(largeNoisyImg[i+l,j+m]-largeNoisyImg[i,j])**2)
                    
                    
                    
            # f) Multiplizieren Sie ihren Gaußkern mit den gerade berechneten Ähnlichkeits-gewichten. 
            # Normalisieren Sie die so entstehende Struktur, damit alle Gewichtesich zu eins normieren.
            filterKern = spacialFilter*gaussKernel2d
            filterKern = filterKern/np.sum(filterKern)
            val = 0.0
            for l in range(-k,k+1):
                for m in range(-k,k+1):
                
                    # g) Berechnen Sie den neuen Wert ihres aktuellen Pixels als gewichtete Linear-kombination mit obigen Gewichten.
                    val = val+filterKern[l+k,m+k]*largeNoisyImg[i+l,j+m]
            denoisedBilateral[i-k,j-k] = val
    return denoisedBilateral    

def apply_conv3x3(kernel, img):
    
    # Create Padded Image
    image_padded = np.zeros((img.shape[0] + 2, img.shape[1] + 2))
    out = np.zeros(image_padded.shape)
    he,wi = image_padded.shape
    
    # Add Padding
    for row in range(-1,img.shape[0] + 1):
        for col in range(-1,img.shape[1] + 1):
            image_padded[row+1,col+1] = img[np.mod(row,img.shape[0]), np.mod(col,img.shape[1])]
    
    
    # Rotate Kernel
    kernel_r = np.rot90(kernel, 2)
    
    # Apply Convolution
    for row in range(1,he-1):
        for col in range(1,wi-1):
            out[row, col] = np.sum(image_padded[row-1:row+2,col-1:col+2]*kernel_r)

    return out[1:-1,1:-1]

def transform_colorspace(img):
    sy,sx,sz = img.shape
    vec_img = img.reshape((sy*sx,3)).T
    trans = np.array([[1/np.sqrt(3),1/np.sqrt(3),1/np.sqrt(3)], 
                        [1/np.sqrt(2), 0, -1/np.sqrt(2)],
                        [1/np.sqrt(6),-2/np.sqrt(6),1/np.sqrt(6)]])
    new_vec_img = trans @ vec_img
    new_img = new_vec_img.T.reshape((sy,sx,3))
    return new_img

def transform_colorspace_back(img):
    sy,sx,sz = img.shape
    vec_img = img.reshape((sy*sx,3)).T
    trans = np.array([[1/np.sqrt(3),1/np.sqrt(3),1/np.sqrt(3)], 
                        [1/np.sqrt(2), 0, -1/np.sqrt(2)],
                        [1/np.sqrt(6),-2/np.sqrt(6),1/np.sqrt(6)]])
    new_vec_img = trans.T @ vec_img
    new_img = new_vec_img.T.reshape((sy,sx,3))
    return new_img


def transform_colorchannel_back_and_plot(new_img, old_img, original, transformed):
    
    # Transform to old color space
    img_uncorr = transform_colorspace_back(new_img)
    img_uncorr[img_uncorr>1]=1
    img_uncorr[img_uncorr<0]=0
    old_img[old_img>1]=1
    old_img[old_img<0]=0

    # Channelwise 
    img_R = transformed.copy()
    img_G = transformed.copy()
    img_B = transformed.copy()
    img_R[:,:,0] = new_img[:,:,0]
    img_G[:,:,1] = new_img[:,:,1]
    img_B[:,:,2] = new_img[:,:,2]
    img_R = transform_colorspace_back(img_R)
    img_G = transform_colorspace_back(img_G)
    img_B = transform_colorspace_back(img_B)
    img_R[img_R>1]=1
    img_R[img_R<0]=0
    img_G[img_G>1]=1
    img_G[img_G<0]=0
    img_B[img_B>1]=1
    img_B[img_B<0]=0
    
    # Plot
    plt.figure(figsize=(40,40))
    sp1 = plt.subplot(231)
    sp1.imshow(original)
    plt.title('Original')
    sp1 = plt.subplot(232)
    sp1.imshow(img_uncorr)
    plt.title('Uncorrelated ')
    sp1 = plt.subplot(233)
    sp1.imshow(old_img)
    plt.title('RGB ')
    sp1 = plt.subplot(234)
    sp1.imshow(img_R)
    plt.title('Uncorrelated  - Channel1')
    sp1 = plt.subplot(235)
    sp1.imshow(img_G)
    plt.title('Uncorrelated  - Channel2')
    sp1 = plt.subplot(236)
    sp1.imshow(img_B)
    plt.title('Uncorrelated  - Channel3')
    #plt.show()


def sharpening(alpha, img, new_img_nonoise):
    
    # Run Convolution
    kernel = np.array([[0, -alpha, 0], [-alpha, 4+alpha*4, -alpha], [0, -alpha, 0]])/4
    new_img_sharp = new_img_nonoise.copy()
    old_img_sharp = img.copy()
    
    for i in range(img.shape[2]):
        new_img_sharp[:,:,i] = apply_conv3x3(kernel, new_img_nonoise[:,:,i])
        old_img_sharp[:,:,i] = apply_conv3x3(kernel, img[:,:,i])
        
    transform_colorchannel_back_and_plot(new_img_sharp, old_img_sharp, img, new_img_nonoise)
    
def bilateral_smoothing(img, img_trans):
    w = 5
    sigma_space = 0.05
    sigma_int = 5
    
    new_img_smooth = img_trans.copy()
    old_img_smooth = img.copy()
    
    for i in range(img.shape[2]):
        new_img_smooth[:,:,i] = bilateralFilter(img_trans[:,:,i], w, sigma_space, sigma_int)
        old_img_smooth[:,:,i] = bilateralFilter(img[:,:,i], w, sigma_space, sigma_int)

    transform_colorchannel_back_and_plot(new_img_smooth, old_img_smooth, img, img_trans)

def DCT_Denoising(threshold, img, img_trans):
    new_img_smooth = img_trans.copy()
    old_img_smooth = img.copy()
    
    for i in range(img.shape[2]):
        new_img_smooth[:,:,i] = denoise_DCT(threshold,img_trans[:,:,i])
        old_img_smooth[:,:,i] = denoise_DCT(threshold,img[:,:,i])

    transform_colorchannel_back_and_plot(new_img_smooth, old_img_smooth, img, img_trans)
    
def main():
    
    # Load Image
    img_dir = "statue3.jpg"
    img_pil = Image.open(img_dir)
    img = np.array(img_pil.resize([226,150]))/255
    img_noisy = img + np.random.normal(0,0.05,img.shape)

    # Transform to new color space
    new_img = transform_colorspace(img_noisy)
    new_img_nonoise = transform_colorspace(img)
    
    threshold = 0.05 * 3
    DCT_Denoising(threshold, img, new_img)
    plt.savefig('DCT_Denoising.png', bbox_inches='tight')
    
    sharpening(1, img, new_img_nonoise)
    plt.savefig('sharpening.png', bbox_inches='tight')
    
    bilateral_smoothing(img_noisy, new_img)
    plt.savefig('bilateral_smoothing.png', bbox_inches='tight')


    


if __name__ == "__main__":
    main()




        








