%Class Test
clearvars

%% Load data
f_image = im2double(imread('books.jpg'));
f_image = f_image(101:300,101:300,:);

%% Construct Mosaik operator and input data
[ny,nx,nc]=size(f_image);
red = zeros(ny,nx,nc);
green= zeros(ny,nx,nc);
blue = zeros(ny,nx,nc);
red(1:2:end,1:2:end,1)=1;
blue(2:2:end,2:2:end,3)=1;
green(2:2:end,1:2:end,2)=1;
green(1:2:end,2:2:end,2)=1;
S = kron([1 1 1], speye(nx*ny))*spdiags(red(:)+green(:)+blue(:),0,ny*nx*nc,ny*nx*nc);

f = S*f_image(:);

figure(1) ,imshow(f_image.*cat(3,red(:,:,1),green(:,:,2),blue(:,:,3))), title('input Bayer pattern')


%% Set Huber parameters

eps_val = 0.03;
alpha   = 0.5;

%% Build energy

% Gradient matrix:
dy = spdiags([[-ones(ny - 1, 1); 0], ones(ny, 1)], [0, 1], ny, ny);
dy = kron(speye(nx), dy);
dx = spdiags([[-ones(ny*(nx-1),1); zeros(ny, 1)], ones(nx*ny,1)],[0, ny], nx*ny,nx*ny);
D = cat(1, kron(speye(nc), dx), kron(speye(nc), dy));

% vector valued energy:
% data object:
l2 = @(u) 0.5*sum((S*u-f).^2);
l2Grad = @(u) S'*(S*u-f);

E_l2 = energyClass(l2,l2Grad,nx*ny*nc);


% regularization functions
Huber = @(u) sum(0.5*u.^2.*(abs(u) <= eps_val) + eps_val*(abs(u)-0.5*eps_val).*(1-(abs(u) <= eps_val))); 
HuberGrad = @(u) u.*(abs(u) <= eps_val) + eps_val*sign(u).*(1-(abs(u) <= eps_val));

% regularization object
E_huber = energyClass(@(u) Huber(D*u),@(u) D'*HuberGrad(D*u));


% final variational model
E_final = E_l2 + alpha * E_huber;


%% Run gradient descent
backend.alpha = 0.4;        % backtracking strictness, variable in ]0,0.5[
backend.beta = 0.5;         % backtracking reduction factor, in ]0,1[
backend.maxiters = 750;     % maximum number of iterations
backend.startStep = 1;      % starting tau for each iteration
backend.stopCrit = 1e-4;    % stopping criterion on gradient norm
backend.callback = 25;      % frequency of console prints
tic
[u_out,logfile] = E_final.solve('gradDescent',backend); %% Call solve method for gradient descent, with some options and starting u
toc

%% Show result

u_image = reshape(u_out,nx,ny,nc);

figure(2), imshow(u_image), title('algorithm result');