%Test demosaiking wit infimal convolution TV
clearvars

%% Load data
f_image = im2double(imread('books.jpg'));
f_image = f_image(101:300,101:300,:);

%% Construct Mosaik operator and input data
[ny,nx,nc]=size(f_image);
N = nx*ny*nc;
red = zeros(ny,nx,nc);
green= zeros(ny,nx,nc);
blue = zeros(ny,nx,nc);
red(1:2:end,1:2:end,1)=1;
blue(2:2:end,2:2:end,3)=1;
green(2:2:end,1:2:end,2)=1;
green(1:2:end,2:2:end,2)=1;
S = kron([1 1 1], speye(nx*ny))*spdiags(red(:)+green(:)+blue(:),0,ny*nx*nc,ny*nx*nc);

f = S*f_image(:);

figure(1),imshow(f_image.*cat(3,red(:,:,1),green(:,:,2),blue(:,:,3))), title('input Bayer pattern')


%% Set  parameters
kappa = 0.25;
eps_val = 0.03;
alpha   = 0.25;

%% Build energy

% Define gradient operator as usual
dy = spdiags([[-ones(ny - 1, 1); 0], ones(ny, 1)], [0, 1], ny, ny); 
dy = kron(speye(nx), dy);
dx = spdiags([[-ones(ny*(nx-1),1); zeros(ny, 1)], ones(nx*ny,1)],[0, ny], nx*ny,nx*ny);    
D1 = cat(1, kappa*kron(speye(nc), dx), kron(speye(nc), dy)); % here we insert 0.25 directly into the gradient matrix
D2 = cat(1, kron(speye(nc), dx), kappa*kron(speye(nc), dy));

% Define operators to transfrom v = (u,v)
I10 = [speye(N),spalloc(N,N,0)];      % I10*v = u
I11 = [speye(N), -speye(N)];          % I11*v = u-w
I01 = [spalloc(N,N,0), speye(N)];     % I01*v = w


% Construct vector valued energy:
% data
l2 = @(v) 0.5*sum((S*I10*v-f).^2);
l2Grad = @(v) I10'*S'*(S*I10*v-f);

E_l2 = energyClass(l2,l2Grad,2*N); % variable size is doubled because v is u and w stacked!

% regularizer
Huber = @(u) sum(0.5*u.^2.*(abs(u) <= eps_val) + eps_val*(abs(u)-0.5*eps_val).*(1-(abs(u) <= eps_val))); 
HuberGrad = @(u) u.*(abs(u) <= eps_val) + eps_val*sign(u).*(1-(abs(u) <= eps_val));

% infimal convolution regularization object
E_R1 = energyClass(@(v) Huber(D1*I11*v),@(v) I11'*D1'*HuberGrad(D1*I11*v));
E_R2 = energyClass(@(v) Huber(D2*I01*v),@(v) I01'*D2'*HuberGrad(D2*I01*v));


% % % Alternative: Use eps^2 smoothed TV:
% % l2eps = @(x) sqrt(x(1:N).^2 + x(N+1:2*N).^2 + eps_val^2);              %smoothed l2 norm
% % TV_smooth = @(u) sum(l2eps(u));
% % TV_grad   = @(u) u./[l2eps(u);l2eps(u)];
% % 
% % E_R1 = energyClass(@(v) TV_smooth(D1*I11*v),@(v) I11'*D1'*TV_grad(D1*I11*v));
% % E_R2 = energyClass(@(v) TV_smooth(D2*I01*v),@(v) I01'*D2'*TV_grad(D2*I01*v));
% % However smoothing with Huber is faster, set alpha = 0.01, eps_val = 0.01 if using smooth TV

% final variational model
E_final = E_l2 + alpha * (E_R1+E_R2);


%% Run gradient descent
backend.alpha = 0.4;        % backtracking strictness, variable in ]0,0.5[
backend.beta = 0.5;         % backtracking reduction factor, in ]0,1[
backend.maxiters = 750;     % maximum number of iterations
backend.startStep = 1;      % starting tau for each iteration
backend.stopCrit = 1e-4;    % stopping criterion on gradient norm
backend.callback = 25;      % frequency of console prints
tic
[u_out,logfile] = E_final.solve('gradDescent',backend); %% Call solve method for gradient descen
toc

% % Note: The convergence of infimal convolution schemes is generally much slower than
% %     the other convex problems we discussed before, due to the coupling of u and w.
%% Show result

u_image = reshape(u_out(1:N),nx,ny,nc);
w_image = reshape(u_out(N+1:2*N),nx,ny,nc);

figure(2), imshow(u_image), title('algorithm result');

%% Show decomposition

part1 = u_image-w_image;
part2 = w_image;
for i=1:3 % To show the correct decomposition we have to correct the constants
    part1(:,:,i) = part1(:,:,i)-mean(mean(part1(:,:,i)));
    part1(:,:,i) = part1(:,:,i)+mean(mean(u_image(:,:,i)));
    part2(:,:,i) = part2(:,:,i)-mean(mean(part2(:,:,i)));
    part2(:,:,i) = part2(:,:,i)+mean(mean(u_image(:,:,i)));
end
figure(3), imshow(part1), title('vertically decomposed part')
figure(4), imshow(part2), title('horizontally decomposed part')