%
% Denoising with Huber-TV / double-opponent Huber-TV
%
clearvars

%% Load data
f_image = im2double(imread('ein_ei.jpg'));
f_image = f_image(101:300,101:300,:);

[nx,ny,nc] = size(f_image);

figure(1),imshow(f_image),title('ground truth');



%% Add noise
f= f_image(:) + 0.1*randn(nx*ny*nc,1);

figure(2), imshow(reshape(f,nx,ny,nc)),title('noisy image');
drawnow

%% Set Huber parameters

eps_val = 0.03;
alpha   = 1.5;

%% Build energy
% data object
l2 = @(u) 0.5*sum((u-f).^2);
l2Grad = @(u) (u-f);

E_l2 = energyClass(l2,l2Grad,nx*ny*nc);
% regularizer object
Huber = @(u) sum(0.5*u.^2.*(abs(u) <= eps_val) + eps_val*(abs(u)-0.5*eps_val).*(1-(abs(u) <= eps_val))); 
HuberGrad = @(u) u.*(abs(u) <= eps_val) + eps_val*sign(u).*(1-(abs(u) <= eps_val));

D = spmat_gradient2d(ny, nx, nc);
combinations = [1,1,0;
                1,0,1;
                0,1,1];
D2 = kron(combinations,spmat_gradient2d(ny,nx,1));
D = [D;D2]; % double opponent TV

E_huber = energyClass(@(u) Huber(D*u),@(u) D'*HuberGrad(D*u));

% final variational model
E_final = E_l2 + alpha * E_huber;


%% Run gradient descent
backend.alpha = 0.1;        % backtracking strictness, variable in ]0,0.5[
backend.beta = 0.5;         % backtracking reduction factor, in ]0,1[
backend.maxiters = 100;     % maximum number of iterations
backend.startStep = 1;      % starting tau for each iteration
backend.stopCrit = 1e-5;    % stopping criterion on gradient norm
backend.callback = 5;       % frequency of console prints
tic
[u_out,logfile] = E_final.solve('gradDescent',backend,f); %% Call solve method for gradient descent, with some options and starting u
toc

%% Show result

u_image = reshape(u_out,nx,ny,nc);

figure(3), imshow(u_image), title('algorithm result');