% This function was extracted from the following code:
% MATLAB code for implementation of iterative adaptive image deblurring
% algorithm:
% A. Kheradmand and P. Milanfar, A general framework for regularized, similarity-based image restoration, 
% IEEE Transactions on Image Processing, vol. 23, no. 12, pp. 51365151, Dec 2014.
% This is experimental software. It is provided for non-commercial research purposes only. Use at your own risk. No warranty is implied by 
% this distribution. Copyright  2014 by University of California.

function shifted = ImShift(v,xShift,yShift)
% 2D Shift of the Input Image
shifted = zeros(size(v));
if (xShift<=0 && yShift<=0)
    shifted(-xShift+1:end,-yShift+1:end) = v(1:end+xShift,1:end+yShift);
elseif (xShift<=0 && yShift>0)
    shifted(-xShift+1:end,1:end-yShift) = v(1:end+xShift,yShift+1:end);
elseif (xShift>0 && yShift<=0)
    shifted(1:end-xShift,-yShift+1:end) = v(xShift+1:end,1:end+yShift);
else
    shifted(1:end-xShift,1:end-yShift) = v(xShift+1:end,yShift+1:end);
end
end