% unknown hyperparameters to find
a1True = 0.5;
a2True = 2*pi;
% simulated measurements
x = linspace(-1,1,20);
curve = @(a1,a2)a1*cos(x*a2); % function to be fitted
y = curve(a1True,a2True)+0.02*randn(size(x));
figure, plot(x,y,'x', 'markersize', 14, 'linewidth', 3)

% for a nicer plot 
xplot = linspace(-1,1,200);
curvePlot = @(a1,a2)a1*cos(xplot*a2);

% starting point
a1 = a1True + 0.2*randn(1);
a2 = a2True + 2*randn(1);
title('Noisy measurements and initial guess')
hold on, plot(xplot,curvePlot(a1,a2));
legend('Measurement', 'Initial guess');
set(gca, 'fontsize', 16);

%% define derivatives gradient and hessian

%% acutal minimization 
% INSERT YOUR CODE BELOW
% DEFINE HYPERPARAMETERS
maxiter = 100;
for i=1:maxiter
    %IMPLEMENT THE METHOD
    
    
    % plot current estimate
    hold off, plot(x,y,'x', 'markersize', 14, 'linewidth', 3)
    hold on, plot(xplot,curvePlot(a1,a2));
    drawnow;
end