import numpy as np


def load_data(path, num_train):
    with open(path, "rb") as f:    # load data
        data = np.loadtxt(f, delimiter=";", skiprows=1)
    
    X = np.hstack((data[:, :-1], np.ones((data.shape[0], 1))))    # create design matrix X
    Y = data[:, -1]                                               # targets y
    
    X_train = X[:num_train]
    Y_train = Y[:num_train]

    X_test = X[num_train:]
    Y_test = Y[num_train:]
    
    return X_train, Y_train, X_test, Y_test

def fit(X, Y):
    theta = np.linalg.solve(X.T @ X, X.T @ Y)
    return theta

def predict(X, theta):
    Y = X @ theta
    return Y

def energy(Y_pred, Y_gt):
    return((Y_pred - Y_gt) ** 2).sum()
