function [u_hat] = challenge_huber_inpainting(mask, f, D, lambda, epsilon, beta, delta, E_star)
% CHALLENGE_HUBER_INPAINTING  
% 
% Implement your algorithm to minimize the Huber-inpainting energy
% given on the slide with title "Fast optimization challenge" in chapter 2. 
%
% Input parameters:
%  - mask: N-dimensional vector, is either 0 or 1.
%  - f: N-dimensional vector, image to be inpainted.
%  - D: 2N x N-dimensional finite difference matrix.
%  - lambda: parameter in front of data term
%  - epsilon: parameter of the huber penalty
%  - beta: parameter in front of squared term
%  - delta: stopping tolerance
%  - E_star: energy of globally optimal solution
%
% Expected output:
%  - u_hat: N-dimensional vector, solution to the minimization
%           problem satisfying (E(u_hat) - E_star) / E_star < delta
    
% !!! TODO: implement your minimization method here !!!
    N = size(f, 1);
    u_hat = zeros(N, 1); 
    
end
