%
%
clearvars
%% Test script Ex2
% target dimension:

n = 500;

% Generate random vector
f = rand(n,1);

% Generate random matrix Q
Q0 = rand(n,n);
Q = 0.5*(Q0+Q0');
Q = Q + n*eye(n);
Q0 = sqrtm(Q);
%Q = Q0'*Q0; % This is also a possibility to generate Q, but then cond(Q)
             % will be quite bad, possible too bad for a decent gradient
             % descent, as it will be slowed down significantly

% First test:
xQx = energy(@(x) 0.5*x'*Q*x,@(x) Q*x); 
fx  = energy(@(x) -f'*x,@(x) -f);

Eu = xQx + fx;
% solve from random starting vector
u0 = rand(n,1);
u_star = Eu.solve(u0);

% Compare to matlab solution 
u_matlab = Q\f;
norm(u_star-u_matlab)


% Even more verbose for testing of overloads:

xtx = energy(@(x) x'*x,@(x) 2*x); 
bx  = energy(@(x) -x,@(x) -1);

Eu2 = (0.5*xtx)*Q0 + bx*f';

u_star2 = Eu2.solve(u0);
norm(u_star2-u_matlab)

%% Test Script Ex3
% Load Input
f0 = im2double(imread('peppers.png'));
f1 = imnoise(f0,'gaussian',0.01);
[m,n,~] = size(f1);
% Show images
figure(1),imagesc(f0),title('Ground truth image');
figure(2),imagesc(f1),title('Noisy image');


% Set parameters
eps_val = 0.5;
alpha   = 0.15;


% Define energies
% Data:
data_term = energy(@(u) sum((u-f1(:)).^2), @(u) u-f1(:));

% Regularizer:
% 1d function h_eps and its derivative:
h_eps = @(u) 0.5*u.^2.*(abs(u)<=eps_val) ...
                        +eps_val*(abs(u)-0.5*eps_val).*(abs(u)>eps_val);
                    
dh_eps = @(u)  u.*(abs(u)<=eps_val) ...
                        +eps_val*(sign(u)).*(abs(u)>eps_val);
% Plot regularizer
interval = linspace(-0.5,0.5,256);
figure(3),plot(interval,h_eps(interval)), 
hold on, plot(interval,dh_eps(interval)), hold off, 
title('Plot of huber function and its derivative');
                    
                    
% Matrix D, this is only a slight modification from exercise 1
% because the matrix is still a convolution (with filter [-1,1,0])
Dx = spdiags([ones(m,1),-2*ones(m,1),ones(m,1)],[-1,1,0],m,m);
Dy = spdiags([ones(n,1),-2*ones(n,1),ones(n,1)],[-1,1,0],n,n);
D = kron(eye(3),[kron(eye(n),Dx);kron(Dy',eye(m))]);
% Note that the third line has changed!
% In exercise 1, we wanted to add the convolutions in first and second dimension,
% but here we are stacking them instead!
% [A;B] stacks matrices A and B 



% Now we can define the full Huber term
huber_reg = energy(@(u) sum(h_eps(D*u)), @(u) D'*dh_eps(D*u));
% And build the energy
Eu = data_term + alpha*huber_reg;

%% Finally, we use solve,
% starting with the noisy image as initialization
u_out = Eu.solve(f1(:));
         


% Before showing u as an image, we have to go back to the image from 
% the vector u_out
u_image = reshape(u_out,[m,n,3]);
figure(4),imagesc(u_image),title('Output image');

