%
%
clearvars
%% Test script Ex2
% target dimension:

n = 500;

% Generate random vector
f = rand(n,1);

% Generate random matrix Q
Q0 = rand(n,n);
Q = 0.5*(Q0+Q0');
Q = Q + n*eye(n);
Q0 = sqrtm(Q);
%Q = Q0'*Q0; % This is also a possibility to generate Q, but then cond(Q)
             % will be quite bad, possible too bad for a decent gradient
             % descent, as it will be slowed down significantly

% First test:
xQx = energy(@(x) 0.5*x'*Q*x,@(x) Q*x); 
fx  = energy(@(x) -f'*x,@(x) -f);

Eu = xQx + fx;
% solve from random starting vector
u0 = rand(n,1);
u_star = Eu.solve(u0);

% Compare to matlab solution 
u_matlab = Q\f;
norm(u_star-u_matlab)


% Even more verbose for testing of overloads:

xtx = energy(@(x) x'*x,@(x) 2*x); 
bx  = energy(@(x) -x,@(x) -1);

Eu2 = (0.5*xtx)*Q0 + bx*f';

u_star2 = Eu2.solve(u0);
norm(u_star2-u_matlab)

