% Exercise Sheet 3
% Variational Methods in Computer Vision 17/18
% Sample Solution
% Mail jonas.geiping@uni-siegen.de for questions.
% Tested with MatlabR2017b

clearvars

%% Test Script Sheet 3
% Exercise 3
% Load Input
f0 = im2double(imread('peppers.png'));
f1 = imnoise(f0,'gaussian',0.08);
[m,n,~] = size(f1);
% Show images
figure(1),imagesc(f0),title('Ground truth image');
figure(2),imagesc(f1),title('Noisy image');

%%
% Set parameters
eps_val = 0.05;
alpha   = 2.5;


% Define energies
% Data:
data_term = energy(@(u) 0.5*sum((u-f1(:)).^2), @(u) u-f1(:));

% Regularizer:
% 1d function h_eps and its derivative:
h_eps = @(u) 0.5*u.^2.*(abs(u)<=eps_val) ...
                        +eps_val*(abs(u)-0.5*eps_val).*(abs(u)>eps_val);
                    
dh_eps = @(u)  u.*(abs(u)<=eps_val) ...
                        +eps_val*sign(u).*(abs(u)>eps_val);
% Plot regularizer
interval = linspace(-0.5,0.5,256);
figure(3),plot(interval,h_eps(interval)), 
hold on, plot(interval,dh_eps(interval)), hold off, 
title('Plot of huber function and its derivative');
  %%                  
                    
% Matrix D, this is only a slight modification from exercise 1
% because the matrix is still a convolution (with filter [-1,1,0])
Dx = spdiags([-ones(m,1),ones(m,1)],[-1,0],m,m);
Dy = spdiags([-ones(n,1),ones(n,1)],[-1,0],n,n);
D = kron(eye(3),[kron(eye(n),Dx);kron(Dy',eye(m))]);
% Note that the third line has changed!
% In exercise 1, we wanted to add the convolutions in first and second dimension,
% but here we are stacking them instead!
% [A;B] stacks matrices A and B 


%%
% Now we can define the full Huber term
huber_reg = energy(@(u) sum(h_eps(D*u)), @(u) D'*dh_eps(D*u));
% And build the energy
Eu = data_term + alpha*huber_reg;

% Finally, we use solve,
% starting with the noisy image as initialization
u_out = Eu.solve(f1(:));
         


% Before showing u as an image, we have to go back to the image from 
% the vector u_out
u_image = reshape(u_out,[m,n,3]);
figure(4),imagesc(u_image),title('Output image - Stacked Huber');
%psnr(u_image,f0)
%% Sheet 3, Exercise 4
% Define D2:

% First define a matrix that sums over color channels
S_kernel  = [1,1,0;
             0,1,1;
             1,0,1];
% We want to apply this matrix to a vector u, so that the output is
% a vector three times the size of u with 
% "[u(i,j,1)+u(i,j,2); u(i,j,2)+u(i,j,3);  u(i,j,1)+u(i,j,3)]"; 

S = kron(S_kernel,speye(m*n));
% Alternative:
% Def I = speye(m*n);
% Def Z  =zeros(m*n);
% S = [I,I,Z;
%      Z,I,I;
%      I,Z,I];
% but this is exactly what kron(S_kernel,I) does.
% 

% Let's look at S to check if it does the right thing:
figure(5), spy(S)
%% Now we have a new vector u_hat, where we just apply our previous gradient matrix
% so applying first, S and then D, is equivalent to applying D*S:
D2 = D*S;
DD = [D;D2];

% Our new regularizer is now
huber_reg_double_opponent = energy(@(u) sum(h_eps(DD*u)), @(u) DD'*dh_eps(DD*u));
% and we update our energy,
Eu = data_term + alpha*0.5*huber_reg_double_opponent;

% solve,
% starting with the noisy image as initialization
u_out2 = Eu.solve(f1(:));
         


% And review the new output
u_image2 = reshape(u_out2,[m,n,3]);
figure(6),imagesc(u_image2),title('Output image -Double Opponent');
%psnr(u_image2,f0)


%% Sheet 3, Exercise 3 (b)
% (The part with Salt&Pepper noise)

f1 = imnoise(f0,'salt & pepper',0.25);
figure(2),imagesc(f1),title('Noisy image -Salt&Pepper');
% Only our data term changes
data_term_new = energy(@(u) 0.5*sum((u-f1(:)).^2), @(u) u-f1(:));
Eu = data_term_new + alpha*0.5*huber_reg_double_opponent;
% We solve again
u_out3 = Eu.solve(f1(:));
figure(7),imagesc(reshape(u_out3,m,n,3)),title('Output S&P denoised-Quadratic data');
% The quadratic data term tries to average wrong pixel and correct pixel
% this was a good idea for gaussian noise, but for salt&pepper it blurs the
% image too much

%% Let's use the huber function instead:
data_term_huber = energy(@(u) sum(h_eps(u-f1(:))),@(u) dh_eps(u-f1(:)));
Eu = data_term_huber + 0.6*0.5*huber_reg_double_opponent;
% We solve again
% (this will be much slower, as the functional is less suited for gradient
% descent, but that is not part of our lecture)
u_out3 = Eu.solve(f1(:));
figure(8),imagesc(reshape(u_out3,m,n,3)),title('Output S&P denoised- huber data');

% We will see later in the lecture, why this is a better choice  