%
% Sample Solution Demoisaicing
%
clearvars
% 
addpath(genpath('subfunctions'));
% Parameters:
kappa = 0.25;
alpha = 0.1;
eps_val = 0.025;


%% Generate Data
img = imresize(im2double(imread('peppers.png')),0.5);
[m,n,k]=size(img);

[S,f] = generateMosaicMatrix(img);

imgDemosaickMatlab = demosaic(uint8(255*reshape(f, [m,n])),'rggb');

%% Use InfConv TV

data_term = energy(@(u) sum((S*u-f).^2),@(u) S'*(S*u-f));

% Define directional Derivatives
Dx = spdiags([-ones(m,1),ones(m,1)],[-1,0],m,m);
Dy = spdiags([-ones(n,1),ones(n,1)],[-1,0],n,n);
Dx = kron(eye(3),kron(eye(n),Dx));
Dy = kron(eye(3),kron(Dy',eye(m)));

% Define 1d smoothed and weighted norms
l1_2 = @(x,y,k1,k2) sqrt(k1*x.^2+k2*y.^2+eps_val^2);
dl1_2= @(x,y,k1,k2) [k1*x;k2*y]./repmat(l1_2(x,y,k1,k2),2,1);


% Define energies
% These are energies in u                    
Reg1  = energy(@(u) sum(l1_2(Dx*u,Dy*u,kappa,1)),     ...
               @(u) [kappa*Dx;Dy]'*dl1_2(Dx*u,Dy*u,kappa,1));    

Reg2  = energy(@(u) sum(l1_2(Dx*u,Dy*u,1,kappa)),     ...
               @(u) [Dx;kappa*Dy]'*dl1_2(Dx*u,Dy*u,1,kappa));           
 
% Data term, notice the sum over 1:length(u/2), as w is not compared to f
data  = energy(@(u) sum((S*u(1:length(u)/2)-f).^2), ...
               @(u) [S'*(S*u(1:length(u)/2)-f);zeros(m*n*3,1)]);
           
% IC (|) of two energies produces an energy with variable size 2*length(u)
% to account for w by stacking [u;w]
Reg = alpha*(Reg1 | Reg2);
Eu  = data + Reg;
           
           
% We solve as usual, initializing w with zeros
u0 = [S'*f;zeros(m*n*3,1)];
u_out = Eu.solve(u0);       %This may take some time ...

%% Look at result
img_out = reshape(u_out,[m,n,k,2]);
img_result = img_out(:,:,:,1);
figure(3),imagesc(img_result),title('Our Demosaicing');

%% Show decomposition:
img_vert = img_out(:,:,:,2);
img_horz = img_out(:,:,:,1)-img_out(:,:,:,2);
img_vert = img_vert-mean(mean(img_vert))+mean(mean(img_result));
img_horz = img_horz-mean(mean(img_horz))+mean(mean(img_result));
figure(4),imagesc(img_horz),title('Horizontal Part');
figure(5),imagesc(img_vert),title('Vertical Part');
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            