function [tv_energy] = TV_reg_smooth(size_img,eps_val)
%
% Huber functions
% Output: energy object

m = size_img(1); n= size_img(2); k = size_img(3);
x = m*n*k;


% Define 1D huber functions
r_eps = @(t) sqrt(t(1:x).^2+t(x+1:end).^2+eps_val^2);
                    
dr_eps = @(t) t./repmat(r_eps(t),2,1);
                  
% Define Gradient Matrix
Dx = spdiags([-ones(m,1),ones(m,1)],[-1,0],m,m);
Dy = spdiags([-ones(n,1),ones(n,1)],[-1,0],n,n);
D = kron(eye(3),[kron(eye(n),Dx);kron(Dy',eye(m))]);

% Define energy

tv_energy = energy(@(u) sum(r_eps(D*u)),@(u) D'*dr_eps(D*u));

end

