function [S,f] = generateMosaicMatrix(img)
% Creates mosaic matrix S and output mosaic image
% 

[m,n,k]=size(img);

red = zeros(m,n,k);
green= zeros(m,n,k);
blue = zeros(m,n,k);
red(1:2:end,1:2:end,1)=1;
blue(2:2:end,2:2:end,3)=1;
green(2:2:end,1:2:end,2)=1;
green(1:2:end,2:2:end,2)=1;
S = kron([1 1 1], speye(m*n))*spdiags(red(:)+green(:)+blue(:),0,m*n*k,m*n*k);

f = S*img(:);
figure(1), imagesc(img.*(red+green+blue)),title('Input Data (Bayer Pattern)');
end

