function [huber_energy] = huber_reg(size_img,eps_val,huber_type)
%
% Huber functions
% Output: energy object




% Define 1D huber functions
h_eps = @(u) 0.5*u.^2.*(abs(u)<=eps_val) ...
                        +eps_val*(abs(u)-0.5*eps_val).*(abs(u)>eps_val);
                    
dh_eps = @(u)  u.*(abs(u)<=eps_val) ...
                        +eps_val*sign(u).*(abs(u)>eps_val);
                  
% Define Gradient Matrix
m = size_img(1); n= size_img(2); k = size_img(3);

Dx = spdiags([-ones(m,1),ones(m,1)],[-1,0],m,m);
Dy = spdiags([-ones(n,1),ones(n,1)],[-1,0],n,n);
D = kron(eye(3),[kron(eye(n),Dx);kron(Dy',eye(m))]);


switch lower(huber_type)
    
    case 'normal'
        % Normal Huber
        huber_energy = energy(@(u) sum(h_eps(D*u)), @(u) D'*dh_eps(D*u));
        
    case 'double opponent'
        % Double Opponent Huber
        if k ~= 3
            error('Double opponent is only interesting for color images.');
        end
        S_kernel  = [1,1,0;
                     0,1,1;
                     1,0,1];
        S = kron(S_kernel,speye(m*n));
        D2 = D*S;
        DD = [D;D2];
        huber_energy = energy(@(u) 0.5*sum(h_eps(DD*u)), @(u) 0.5*DD'*dh_eps(DD*u));
        % Normalized with 0.5 to account for the size increase of DD vs D.
end

