% read image and define dimensions of subsampling
u = im2double(imread('cameraman.tif'));
[ny,nx] = size(u);
nSubsampled = 128;
% create subsampling matrices
Sx = xDirectionDownsamplingMatrix(nSubsampled,nx);
Sy = (xDirectionDownsamplingMatrix(nSubsampled,ny))';

% illustration
figure, imshow(u) % original image
figure, imshow(u*Sx) % subsampled in x-direction only
figure, imshow(Sy*u) % subsampled in y-direction only
figure, imshow(Sy*u*Sx) % fully subsampled

% illustration of the vectorization: By using the kronecker product the
% above left-right-multiplication is the same as a big matrix-vector
% multiplication.
DownSamp = kron(Sx',Sy);
figure, imshow(reshape(DownSamp*u(:), [nSubsampled,nSubsampled]));

