function [nl_energy] = nl_reg(imgIn,krad,wrad,h,norm_type)
%Build nonlocal regularization
%

W = Integral_NLM(imgIn,krad,wrad, h); % This is costly

d = full(sum(W,2));
D = spdiags(d, 0, size(W,1), size(W,2));

switch norm_type
    
    case 'D-W'
        L = D-W;
        L = kron(speye(3),L);
        
    case 'normed'
        sqD = spdiags((1./sqrt(diag(D))),0,size(W,1),size(W,2));
        L = speye(size(W))-sqD*W*sqD;
        L = kron(speye(3),L);
end
    
% Build energy
nl_energy = energy(@(u) 0.5*u'*L*u, @(u) L*u);
end

