function Sx = xDirectionDownsamplingMatrix(newDim,oldDim)
	% determine old and new grid 
    Xgrid    = 1:oldDim;
    step     = oldDim/newDim;
    XgridNew = (1+step/2:step:oldDim+1) - 0.5;
    Sx = sparse(oldDim,newDim);
    for i=1:oldDim
       vector = zeros([1,oldDim]);
       vector(i) = 1;
       Sx(i,:) = interp1(Xgrid,vector,XgridNew,'linear');
    end
    