function stitched = showStitchingResults(I1col, I2col, params)

img1 = im2double(I1col);
[n,m,c] = size(img1);
tform = maketform('affine',[reshape(params, [2 3])', [0 0 1]']);
[XData1, YData1] = tformfwd(tform,[1 m],[1 n]);
if XData1(1)>1
    XData1(1)=1;
end
if YData1(1)>1
    YData1(1)=1;
end
XData1 = [min(0,XData1(1)), max(XData1(2),m)];
yData1 = [min(0,YData1(1)), max(YData1(2),n)];
for i=1:c
    img1Warped(:,:,i) = imtransform(img1(:,:,i),tform,'XData',XData1,'YData',YData1);
    presence1(:,:,i) = imtransform(ones(size(img1(:,:,i))),tform,'XData',XData1,'YData',YData1);
    
    presence2(:,:,i) = imtransform(ones(size(I2col(:,:,i))),maketform('affine',eye(3)),'XData',XData1,'YData',YData1);
    img2(:,:,i)=imtransform(im2double(I2col(:,:,i)),maketform('affine',eye(3)),'XData',XData1,'YData',YData1);
end
%figure,imshow(img1Warped);

stitched = (img1Warped + img2)./(presence1+presence2);
figure, imshow(stitched)